class RythornAirlineAI extends AIInfo {
  function GetAuthor()      { return "Sevestra Rythorn"; }
  function GetName()        { return "Rythorn Airline AI"; }
  function GetDescription() { return "Rythorn Airline AI by Sevestra Rythorn is a fork of WrightAI that adds some customization without changing too much of the underlying mechanics. It also contains code that picks a company name and company president from a list of characters from my work in progress book, The Chronicles of Rythorn. Said code was found on the TT-Forums in a thread by Asimov answered by Yexo and customized by me."; }
  function GetVersion()     { return 3; }
  function GetDate()        { return "2012-09-06"; }
  function CreateInstance() { return "RythornAirlineAI"; }
  function GetShortName()   { return "RAAI"; }
  function GetAPIVersion()  { return "1.0"; }
  function GetSettings() {
		AddSetting({name = "min_town_size", description = "The minimum size of towns to work with", min_value = 100, max_value = 2500, easy_value = 2000, medium_value = 1500, hard_value = 1000, custom_value = 1500, flags = 0});
		AddSetting({name = "min_money_route", description = "The minimum amount of money needed to build a route", min_value = 100000, max_value = 500000, easy_value = 100000, medium_value = 200000, hard_value = 300000, custom_value = 100000, flags = 0});
		AddSetting({name = "min_money_aircraft", description = "The minimum amount of money needed to build an aircraft", min_value = 50000, max_value = 300000, easy_value = 100000, medium_value = 150000, hard_value = 200000, custom_value = 200000, flags = 0});
		AddSetting({name = "min_money_costly_aircraft", description = "The minimum amount of money needed to build an expensive aircraft", min_value = 100000, max_value = 500000, easy_value = 200000, medium_value = 350000, hard_value = 500000, custom_value = 350000, flags = 0});
		AddSetting({name = "min_profit_keep_aircraft", description = "Only keep an aircraft if it makes x amount of cash per year", min_value = 5000, max_value = 25000, easy_value = 10000, medium_value = 15000, hard_value = 20000, custom_value = 15000, flags = 0});
		AddSetting({name = "loan_check_speed", description = "Check loan and pay off if possible every x ticks (Less = faster, Watch your CPU though)", min_value = 1000, max_value = 5000, easy_value = 5000, medium_value = 3500, hard_value = 2000, custom_value = 3500, flags = 0});
		AddSetting({name = "route_check_speed", description = "Check routes and manage them every x ticks (Less = faster, Watch your CPU though)", min_value = 500, max_value = 2500, easy_value = 2500, medium_value = 1750, hard_value = 1000, custom_value = 1750, flags = 0});
		AddSetting({name = "event_check_speed", description = "Check events and deal with them every x ticks (Less = faster, Watch your CPU though)", min_value = 50, max_value = 250, easy_value = 250, medium_value = 175, hard_value = 100, custom_value = 175, flags = 0});
		AddSetting({name = "sleep_speed", description = "Sleep for x ticks when there's nothing to do (Less = faster, Watch your CPU though)", min_value = 50, max_value = 250, easy_value = 200, medium_value = 150, hard_value = 100, custom_value = 150, flags = 0});
	}
}

/* Tell the core we are an AI */
RegisterAI(RythornAirlineAI());