/**
 *    This file is part of OtviAI.
 *
 *    OtviAI is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    OtviAI is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with OtviAI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2008-2013 Otto Visser.
 * Suggestions/comments and bugs can go to: OtviAI@otvi.nl
 */

class OtviUtil {
	static function getPassengerCargoID() {
/*		local list = AICargoList();
		for (local i = list.Begin(); !list.IsEnd(); i = list.Next()) {
			if (AICargo.HasCargoClass(i, AICargo.CC_PASSENGERS) && AICargo.GetTownEffect(i) == AICargo.TE_PASSENGERS) {
				Debug("Found passenger cargo: " + AICargo.GetCargoLabel(i));
				return i;
			}
		}*/
		return ::PASSENGER_ID;
	}

	static function getMailCargoID() {
/*		local list = AICargoList();
		for (local i = list.Begin(); !list.IsEnd(); i = list.Next()) {
			if (AICargo.HasCargoClass(i, AICargo.CC_MAIL) && AICargo.GetTownEffect(i) == AICargo.TE_MAIL) {
				Debug("Found mail cargo: " + AICargo.GetCargoLabel(i));
				return i;
			}
		}*/
		return ::MAIL_ID;
	}
}

/**
 * Add a rectangular area to an AITileList containing tiles that are within /radius/
 * tiles from the center tile, taking the edges of the map into account.
 */  
function SafeAddRectangle(list, tile, radius, exclude_radius = 0) {
	if (tile == null) {
		Error("Got a nullpointer");
		return;
	}

	local x1 = max(1, AIMap.GetTileX(tile) - radius);
	local y1 = max(1, AIMap.GetTileY(tile) - radius);
	
	local x2 = min(AIMap.GetMapSizeX() - 2, AIMap.GetTileX(tile) + radius);
	local y2 = min(AIMap.GetMapSizeY() - 2, AIMap.GetTileY(tile) + radius);
	
	list.AddRectangle(AIMap.GetTileIndex(x1, y1),AIMap.GetTileIndex(x2, y2));

	if (exclude_radius > 0) {
		x1 = max(1, AIMap.GetTileX(tile) - exclude_radius);
		y1 = max(1, AIMap.GetTileY(tile) - exclude_radius);

		x2 = min(AIMap.GetMapSizeX() - 2, AIMap.GetTileX(tile) + exclude_radius);
		y2 = min(AIMap.GetMapSizeY() - 2, AIMap.GetTileY(tile) + exclude_radius);

		list.RemoveRectangle(AIMap.GetTileIndex(x1, y1),AIMap.GetTileIndex(x2, y2));
	}
}

/**
 * Create an array from an AIList.
 */
function ListToArray(l) {
	local a = [];
	foreach (item in l)
		a.append(item);

	return a;
}

function GetTicksPerDay() {
	//measure the number of ticks per day.
	local dateOne = AIDate.GetCurrentDate();
	while (dateOne == AIDate.GetCurrentDate()) {
		Sleep(1);
	}

	dateOne = AIDate.GetCurrentDate();
	local tickOne = AIController.GetTick();
	while (dateOne == AIDate.GetCurrentDate()) {
		Sleep(1);
	}

	local tickTwo = AIController.GetTick();
	local ticksPerDay = tickTwo - tickOne;
	return ticksPerDay;
	Debug("Ticks per day: " + ticksPerDay);
}
	
function GetDate() {
	local date = AIDate.GetCurrentDate();
	return "" + AIDate.GetYear(date) + "-" + AIDate.GetMonth(date) + "-" + AIDate.GetDayOfMonth(date);
}

function arrangeBalance(requestedBalance) {
	local balance = AICompany.GetBankBalance(AICompany.COMPANY_SELF);

	if (balance > requestedBalance)
		return true;	// that was easy

	local loan = AICompany.GetLoanAmount();
	local max = AICompany.GetMaxLoanAmount();

	if (loan == max)
		return false;	// not enough on the balance and loan is already max

	if (max - loan + balance < requestedBalance)
		return false;	// we can't arrange that much

	local mod = AICompany.GetLoanInterval();
	local extra = requestedBalance - balance;
	local extraMod = (extra + mod - 1)/mod;	// round up
	local newLoan = loan + extraMod * mod;
	if (newLoan > max)
		newLoan = max;

	AICompany.SetLoanAmount(newLoan);
}

function Debug(s) {
	AILog.Info(GetDate() + ": " + s);
}

function Warning(s) {
	AILog.Warning(GetDate() + ": " + s);
}

function Error(s) {
	AILog.Error(GetDate() + ": " + s);
}

function GetTick() {                                                                                                                      
	return ::INSTANCE.GetTick();                                                                                                          
}

