/*
 *
 * Copyright (c) 2009, Dustin Andrews
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or 
 *  other materials provided with the distribution.
 * 
 * The names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

//The bee path finder attempts to find a path around obstacles by flying a box pattern around them.
// Currently not being used. main.nut now holds a list of "ignoreTiles" that include a box around the city
// centers to allow the ant pathfinder to more easily navigate around them.
// Bee was super fast, but there were bugs with the join points with crow and this implementation 
// is too unwound to make bug fixing effecient.

require("AntPathFinder.nut");

class BeePathFinder
{
  start = null;
  goal = null;
  current = null;
  path = null;
  count = null;
  x1 = null;
  x2 = null;
  y1 = null;
  y2 = null;

  constructor(start, goal)
  {
    this.start = start;
    this.current = start;
    this.goal = goal;
    this.count = 1;
    this.path = AIList();
    this.path.AddItem(start, count);
    x1 = AIMap.GetTileX(start);
    y1 = AIMap.GetTileY(start);
  
    x2 = AIMap.GetTileX(goal);  
    y2 = AIMap.GetTileY(goal);
  }

}

function BeePathFinder::FindPath()
{
  return false;
  local foundPath = false;
  
  if(x1 < x2 && y1 < y2) // Start NorthWest
  {
    foundPath = this.CheckNWtoSE();
  }
  
  if(x1 > x2 && y1 < y2)// Start SouthWest
  {
    foundPath = this.CheckSWtoNE();
  }
  
  if(x1 < x2 && y1 > y2)// start NorthEast
  {
    foundPath = this.CheckNEtoSW();
  }
  
  if(x1 > x2 && y1 > y2)// start SouthEast
  {
    foundPath = this.CheckSEtoNW();
  }

  if(foundPath)
  {
    foreach(tile, v in path)
    {
      AISign.BuildSign(tile, "B");
    }
    return true;
  }
  
  this.path = null;
  return false;
}

function BeePathFinder::CheckPath(tiles)
{
  if(tiles.Count() == 0) { throw "Unexpected empty list."};
  
  local startCount = tiles.Count();
  local checkList = AIList();
  checkList.AddList(tiles);

  checkList.Valuate(AntPathFinder.isBuildable);
  checkList.KeepValue(1);
  
  if(startCount == checkList.Count())
  {
    print ("Bee prevails. " + startCount);
    return true;
  }
}

function BeePathFinder::CheckNWtoSE()
{
  local tile = start;
  
  local tiles = this.GetESLeg(tile);
  if(this.CheckPath(tiles))
  {
    this.path.AddList(tiles);
    return true;
  }
  
  count = 0;
  tiles = this.GetSELeg(tile);
  if(this.CheckPath(tiles))
  {
    //this.path.AddList(tiles);
    this.path = tiles;
    return true;
  }
  
  return false;
}

function BeePathFinder::CheckNEtoSW()
{
  local tile = start;
  
  local tiles = this.GetWSLeg(tile);
  if(this.CheckPath(tiles))
  {
    this.path.AddList(tiles);
    
    path.Sort(AIAbstractList.SORT_BY_VALUE, true);
    return true;
  }
  
  count = 0;
  tiles = this.GetSWLeg(tile);
  if(this.CheckPath(tiles))
  {
    this.path.AddList(tiles);
    
    path.Sort(AIAbstractList.SORT_BY_VALUE, true);
    return true;
  }
  
  return false;
}


function BeePathFinder::CheckSEtoNW()
{
  local tile = start;
  
  local tiles = this.GetWNLeg(tile);
  if(this.CheckPath(tiles))
  {
    this.path.AddList(tiles);
    
    path.Sort(AIAbstractList.SORT_BY_VALUE, true);
    return true;
  }
  
  count = 0;
  tiles = this.GetNWLeg(tile);
  if(this.CheckPath(tiles))
  {
    this.path.AddList(tiles);
    
    path.Sort(AIAbstractList.SORT_BY_VALUE, true);
    return true;
  }
  
  return false;
}

function BeePathFinder::CheckSWtoNE()
{
  local tile = start;
  
  local tiles = this.GetENLeg(tile);
  if(this.CheckPath(tiles))
  {
    this.path.AddList(tiles);
    
    path.Sort(AIAbstractList.SORT_BY_VALUE, true);
    return true;
  }
  
  count = 0;
  tiles = this.GetNELeg(tile);
  if(this.CheckPath(tiles))
  {
    this.path.AddList(tiles);
    
    path.Sort(AIAbstractList.SORT_BY_VALUE, true);
    return true;
  }
  
  return false;
}



function BeePathFinder::GetESLeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToEast(tile);
      tiles.AddItem(tile, count++);
    }
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToSouth(tile);
      tiles.AddItem(tile, count++);
    }
        
    return tiles;
}

function BeePathFinder::GetSELeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToSouth(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToEast(tile);
      tiles.AddItem(tile, count++);
    }
    
    tiles.Sort(AIAbstractList.SORT_BY_VALUE, true);
    return tiles;
}

function BeePathFinder::GetWSLeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToWest(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToSouth(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    return tiles;
}


function BeePathFinder::GetWNLeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToWest(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToNorth(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    
    return tiles;
}

function BeePathFinder::GetNWLeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToNorth(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToWest(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    return tiles;
}

function BeePathFinder::GetNELeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToNorth(tile);
      tiles.AddItem(tile, count++);
      //AISign.BuildSign(tile, ""+ count);
    }
    
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToEast(tile);
      tiles.AddItem(tile, count++);
      //AISign.BuildSign(tile, ""+ count);
    }
    
    
    return tiles;
}


function BeePathFinder::GetSWLeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToSouth(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToWest(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    return tiles;
}

function BeePathFinder::GetENLeg(tile)
{
    local tiles = AIList();
    
    for(local i = 0; i < abs(y1 - y2); i ++)
    {
      tile = this.GetTileToEast(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    for(local i = 0; i < abs(x1 - x2); i ++)
    {
      tile = this.GetTileToNorth(tile);
      tiles.AddItem(tile, count++);
    }
    
    
    return tiles;
}


function BeePathFinder::GetTileToNorth(tile)
{
  if(tile == goal) {return;}
  local x = AIMap.GetTileX(tile);
  local y = AIMap.GetTileY(tile);
  
  x--;
  
  return AIMap.GetTileIndex(x,y);
}

function BeePathFinder::GetTileToSouth(tile)
{
  if(tile == goal) {return;}
  local x = AIMap.GetTileX(tile);
  local y = AIMap.GetTileY(tile);
  
  x++;
  
  
  return AIMap.GetTileIndex(x,y);
}

function BeePathFinder::GetTileToWest(tile)
{
  if(tile == goal) {return;}
  local x = AIMap.GetTileX(tile);
  local y = AIMap.GetTileY(tile);
  
  y--;
  
  
  return AIMap.GetTileIndex(x,y);
}

function BeePathFinder::GetTileToEast(tile)
{
  if(tile == goal) {return;}
  local x = AIMap.GetTileX(tile);
  local y = AIMap.GetTileY(tile);
  
  y++;
  
  return AIMap.GetTileIndex(x,y);
}
