/*
 *
 * Copyright (c) 2009, Dustin Andrews
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or 
 *  other materials provided with the distribution.
 * 
 * The names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

class Util
{
    constructor()
    {
    }
}

function Util::GetClosestTile(tile, list)
{
  local newList = AIList();
  newList.AddList(list);
  newList.Valuate(AIMap.DistanceSquare, tile);
  newList.Sort(AIAbstractList.SORT_BY_VALUE, true);
  return newList.Begin();
}

function Util::GetMaxLoan()
{
  local cash = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
  if( cash < AICompany.GetMaxLoanAmount() * 2)
  {
    AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount());
  }
}

function Util::PayDownLoan()
{
  local cash = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
  local interval =  AICompany.GetLoanInterval();
  local loan = AICompany.GetLoanAmount();
  if (loan == 0) {return;}  
  
  local newBalance = max(0, loan - (interval * (cash/interval)));
  AICompany.SetLoanAmount(newBalance);
}

function Util::ClearPathSigns()
{
  local sign = AISignList();
  foreach(i, v in sign)
  {
    local name = AISign.GetName(i);
    if(Util.StringStartsWith(name, "{"))
    {
        AISign.RemoveSign(i);
    }
  }
}


function Util::AddDistancesValuator(tile, tile2, tile3, tile4)
{
  local d1 = AIMap.DistanceSquare(tile, tile2);
  local d2 = AIMap.DistanceSquare(tile, tile3);
  local d3 = AIMap.DistanceSquare(tile, tile4);
  return d1 + d2;
}

function Util::StringStartsWith(string, start)
{
    if(string.len() < start.len()) {return false;}
    for(local i = 0; i < start.len(); i ++)
    {
        if(string[i] != start[i]) {return false;}
    }
    return true;
}

function Util::DebugReplaceSign(tile, text)
{
  if(AIController.GetSetting("display_thinking") == 0)
  {
    return;
  }

  local signs = AISignList();
  signs.Valuate(AISign.GetLocation);
  signs.KeepValue(tile);
  foreach(i, v in signs)
  {
    AISign.RemoveSign(i);
  }
    
  AISign.BuildSign(tile, text);
}