/*
 *
 * Copyright (c) 2009, Dustin Andrews
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or 
 *  other materials provided with the distribution.
 * 
 * The names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

class DenverAndRioGrande extends AIInfo 
{
  function GetAuthor()      { return "Dustin Andrews"; }
  function GetName()        { return "Denver & Rio Grande"; }
  function GetDescription() { return "The Denver & Rio Grande Western Railroad. A frieght train AI by Dustin Andrews. Recomended: NARS, Realistic Accleration. Compatible: default, NARS, 2cc."; }
  function GetVersion()     { return 1; }
  function GetDate()        { return "2009-05-28"; }
  function CreateInstance() { return "DenverAndRioGrande"; }
  function GetShortName()   { return "DUST"; }
  
  function GetSettings() 
  {
    //bool settings
	AddSetting({name = "display_thinking", description = "Display signs showing what the pathfinder is thinking", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
    AddSetting({name = "randomize_station_picks", description = "Randomize industry picks", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN});
    AddSetting({name = "random_names", description = "Random historic names", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
    
    //int settings
    AddSetting({name = "bridge_max_len", description = "Max Bridge Length", easy_value = 50, medium_value = 50, hard_value = 50, custom_value = 50, flags = 0, min_value = 20, max_value = 200, step_size=20});		
    AddSetting({name = "ant_max_len", description = "Longest Ant path. Turn up for rough maps.", easy_value = 50, medium_value = 100, hard_value = 200, custom_value = 100, flags = 0, min_value = 50, max_value = 200, step_size = 50});	
    AddSetting({name = "transport_min_percent", description = "Amount of cargo to try to transport per producer", easy_value = 40, medium_value = 50, hard_value = 70, custom_value = 50, flags = 0, min_value = 20, max_value = 70, step_size = 10});
    AddSetting({name = "fiscal_restraint", description = "Fiscal Restraint", easy_value = 50, medium_value = 50, hard_value = 50, custom_value = 50, flags = 0, min_value = 20, max_value = 70, step_size = 10});
    AddSetting({name = "min_route_dist", description = "Minimum distance route to consider", easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = 0, min_value = 0, max_value = 100, step_size = 50});

    AddLabels("transport_min_percent", {_20 = "Little", _30 = "Low", _40 = "Below average" _50 = "Medium", _60 = "Above average", _70 = "Most" });
    AddLabels("fiscal_restraint", {_20 = "Little", _30 = "Some", _40 = "Below average" _50 = "Average", _60 = "Above average", _70 = "Lots" });
    AddLabels("min_route_dist", {_0 = "Next Door", _50 = "Short", _100 = "Medium" _150 = "Long", _200 = "Very long"});
    

  }
}
RegisterAI(DenverAndRioGrande());















