/*
 * @author Luis Henrique O. Rios (trAIns) Copyright (C) 2009, modified by Daniela Plachtova
 * @file error_manager.nut
 * @note original licence can be found in licence.txt
 */

 /** 
  * @brief class ErrorManager 
  */
class ErrorManager 
{
	/* ERROR CODE Constants: */
	static ERROR_NONE = 0;									/* No error */
	static ERROR_NOT_ENOUGH_CASH = 1;						/* We do not have enough cash */
	static ERROR_TOO_MANY_VEHICLES = 2;						/* We have too many vehicles */
	static ERROR_LOCOMOTIVE_CANNOT_PULL_WAGON = 3;			/* Locomotive is not compatible with this wagon */
	static ERROR_NO_VEHICLES_IN_ROUTE = 4;					/* There are no vehicles in route (route is empty) */
	static ERROR_LOCAL_AUTHORITY_REFUSES = 5;				/* local authority did not allow us to build there */
	static ERROR_NO_SUITABLE_TOWN_PAIR_FOR_RAIL_ROUTE = 6;	/* we did not find suitable two towns for railroute */
	static ERROR_UNKNOWN = 7;								/* unknown error */
	
	/* ERROR CODE constants for air manager*/
	static ERROR_FIND_AIRPORT1	= 10;				/* There was an error finding a spot for airport 1. */
	static ERROR_FIND_AIRPORT2	= 11;				/* There was an error finding a spot for airport 2. */
	static ERROR_BUILD_AIRPORT1	= 12;				/* There was an error building airport 1. */
	static ERROR_BUILD_AIRPORT2	= 13;				/* There was an error building airport 2. */
	static ERROR_FIND_AIRPORT_ACCEPTANCE = 14;		/* We couldn't find a suitable airport but we lowered our acceptance rate limit so we can try again. */
	static ERROR_FIND_AIRPORT_FINAL = 15;			/* We couldn't find a suitable airport and we are at the minimum acceptable acceptance limit. */
	static ERROR_MAX_AIRCRAFT = 16;					/* We have reached the maximum allowed number of aircraft. */
	static ERROR_MAX_AIRPORTS = 17;					/* We have reached the maximum number of airports. */
	static ERROR_BUILD_AIRCRAFT = 18;				/* General error trying to build an aircraft. */
	static ERROR_BUILD_AIRCRAFT_INVALID = 19;		/* No suitable aircraft found when trying to build an aircraft. */
	
	static error_table = ["ERROR_NONE", "ERROR_NOT_ENOUGH_CASH", "ERROR_TOO_MANY_VEHICLES", 
						  "ERROR_LOCOMOTIVE_CANNOT_PULL_WAGON", "ERROR_NO_VEHICLES_IN_ROUTE", 
						  "ERROR_LOCAL_AUTHORITY_REFUSES", "ERROR_NO_SUITABLE_TOWN_PAIR_FOR_RAIL_ROUTE", 
						  "ERROR_UNKNOWN", "EMPTY_SLOT", "EMPTY_SLOT", "EMPTY_SLOT", "ERROR_FIND_AIRPORT1", 
						  "ERROR_FIND_AIRPORT2", "ERROR_BUILD_AIRPORT1", "ERROR_BUILD_AIRPORT2", 
						  "ERROR_FIND_AIRPORT_ACCEPTANCE", "ERROR_FIND_AIRPORT_FINAL", "ERROR_MAX_AIRCRAFT", 
						  "ERROR_MAX_AIRPORTS", "ERROR_BUILD_AIRCRAFT", "ERROR_BUILD_AIRCRAFT_INVALID"];
	
	_last_error = null;								 /* Last error id */
	
	/** 
	 * @brief constructor for ErrorManager
	 */
	constructor(){
		this._last_error = ERROR_NONE;
	}
	
	/**
	 * @brief Set Last Error
	 * @param error last error
	 */
	function SetLastError(error){
		this._last_error = error;
	}
	
	/**
	 * @brief Get Last Error
	 * @return last error
	 */
	function GetLastError(){
		return this._last_error;
	}
	
	/**
	 * @brief Get Last Error String
	 * @return last error string
	 */
	function GetLastErrorString() 
	{
		return error_table[this._last_error];
	}
	
}
