/**
 * @author Daniela Plachtova
 * @file industry_pair.nut
 */
 
 /**
  * @brief class IndustryPair
  */
class IndustryPair {

	_cargo = null;			/* cargo id */
	_value = null;			/* value of producing industry */
	_industry_pro = null;	/* producing industry id */
	_industry_acc = null;	/* accepting industry id */
	
	/**
	 * @brief constructor for IndustryPair
	 * @param industry_pro producing industry 
	 * @param cargo cargo
	 * @param value value of producing industry
	 * @note we set industry_acc later
	 */
	constructor(industry_pro, cargo, value)
	{
		this._industry_pro = industry_pro;
		this._cargo = cargo;
		this._value = value;
		this._industry_acc = null; 
	}
	
	/**
	 * @brief setter for station_acc
	 * @param value station_acc to setter
	 */
	function SetIndustryAcc(value) 
	{
		this._industry_acc = value;
	}
	
	/**
	 * @brief ToString
	 * @return string IndustryPair info
	 */
	function ToString() 
	{
		local industry_acc_name = ((_industry_acc == null) ? "NO INDUSTRY" : AIIndustry.GetName(this._industry_acc));
		return "IndustryPair - Industry PRO: " + AIIndustry.GetName(this._industry_pro) + 
		       " Industry ACC: "  + industry_acc_name + " Cargo: " + AICargo.GetCargoLabel(this._cargo) + 
			   " Distance: " + AIIndustry.GetDistanceManhattanToTile(_industry_pro, AIIndustry.GetLocation(_industry_acc)) + " Value: " + this._value;
	}
	
	/**
	 * @brief Compare function (by value)
	 * @param industry_pair industry pair to compare
	 * @return compared value
	 */
	function _cmp(industry_pair)
	{
		return industry_pair._value - this._value;
	}
	
	/**
	 * @brief auxiliary save function for game
	 * @return industry pair in table
	 */
	function Save() 
	{
		local data = {
			classname = "IndustryPair",
			cargo = this._cargo,
			value = this._value,
			industrypro = this._industry_pro,
			industryacc = this._industry_acc
		}
		return data;
	}
	
	/**
	 * @brief auxiliary save function for game
	 * @param data data to load
	 * @return created IndustryPair
	 */
	function Load(data) 
	{
		local cargo = data["cargo"];
		local value = data["value"];
		local industry_pro = data["industrypro"];
		local industry_acc = data["industryacc"];
		
		local industry_pair = IndustryPair(industry_pro, cargo, value);
		industry_pair.SetIndustryAcc(industry_acc);
		return industry_pair;
	}
}

