/**
 * @author Daniela Plachtova
 * @file town_pair.nut
 */

 
 /**
  * @brief class TownPair
  */
class TownPair
{
	_town1 = null;		/* town1 */
	_town2 = null;		/* town2 */
	
	/**
	 * @brief constructor for TownPair
	 * @param town1 town1
	 * @param town2 town2
	 */
	constructor(town1, town2) 
	{
		_town1 = town1;
		_town2 = town2;
	}
	
	/**
	 * @brief ToString
	 * @return string Town Pair info
	 */
	function ToString() 
	{
		return "TownPair - town1: " + AITown.GetName(this._town1) + " ("+ AITown.GetPopulation(this._town1) + ")"  + 
		                 " town2: " + AITown.GetName(this._town2) + " ("+ AITown.GetPopulation(this._town2) + ")";
	}
	
	/**
	 * @brief Compare function (by population)
	 * @param town_pair town_pair to compare
	 * @return compared value
	 */
	function _cmp(town_pair) 
	{
		return ((AITown.GetPopulation(town_pair._town2) + AITown.GetPopulation(town_pair._town2)) - 
		        (AITown.GetPopulation(this._town1) + AITown.GetPopulation(this._town2)));
	}
	
	/**
	 * @brief auxiliary save function for the game
	 * @return TownPair in data table
	 */
	function Save()
	{
		local data = {
			classname = "TownPair",
			town1 = this._town1,
			town2 = this._town2
		}
		return data;
	}
	
	/**
	 * @brief auxiliary load function for the game
	 * @param data data to load
	 * @return created TownPair
	 */
	function Load(data) 
	{
		return TownPair(data.town1, data.town2);	
	}
}