//
// Original author: Constantin Baranov
//
// Changes made by Zuu aka Leif Linse in the fork 2010-11-25: 
// - Do no longer overwrite the company name upon load of a savegame
// - Make the bank balance feature optional by an AI setting
// - Sleep 27 ticks instead of 10
// - Explicitly tell OpenTTD that the AI should not be used as a random AI

class IdleInfo extends AIInfo {
	function GetAuthor() { return "Zuu"; }
	function GetName() { return "IdleMore"; }
	function GetDescription() {
		return "An Idle AI that does nothing, optionally keeping minimal permissible balance. The bank balance management is disabled by default, but can be switched on in the AI settings - also in running games through the AI debug window. This is a fork of Idle which originally was written by Constantin Baranov";
	}
	function GetVersion() { return 1; }
	function GetDate() { return "2010-11-25"; }
	function CreateInstance() { return "IdleController"; }
	function GetShortName() { return "idmo"; }
	function GetAPIVersion() { return "1.0"; }
	function UseAsRandomAI()  { return false; }

	function GetSettings() {
		AddSetting({name = "maintain_balance", description = "Maintain a minimum balance by adjusting the loan amount", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN | AICONFIG_INGAME});
	}
}

RegisterAI(IdleInfo());
