//
// Original author: Constantin Baranov
//
// For further info see info.nut
//

class IdleController extends AIController {
	new_company = null;

	constructor() {
		this.new_company = true;
	}
}

function IdleController::Start()
{
	if (this.new_company) {
		for (local i = 1; !AICompany.SetName("IdlePlus Transport #" + i); i++)
			;
	}

	for (;;) {
		if (AIController.GetSetting("maintain_balance") == 1) {
			local balance = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
			local step = AICompany.GetLoanInterval();
			local rest = (balance % step + step) % step;
			local loan = AICompany.GetLoanAmount();
			AICompany.SetLoanAmount(loan + (rest - balance));
		}

		this.Sleep(27);
	}
}

function IdleController::Save()
{
	return {};
}

function IdleController::Load(version, data)
{
	this.new_company = false;
}
