/**
 * Class that handles loan repayment.
 */
class AIRepayLoanAction extends TriggerAction
{
/* public */
	function GetName() { return "Loan Repayment";}

/* protected */
	function Execute()
	{
		local loan = AICompany.GetLoanAmount() - this.GetMoneyAmountCanRepay();
		return AICompany.SetLoanAmount(loan) ? 0 : -2;
	}

	function IsReady()
	{
		return this.GetMoneyAmountCanRepay() > 0;
	}

/* private */
	/**
	 * Calculate how many money AI can repay.
	 * @return amount of money AI can repay.
	 */
	function GetMoneyAmountCanRepay()
	{
		local loaned_money = AICompany.GetLoanAmount();
		if (loaned_money == 0) return 0;

		local balance = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
		local step = AICompany.GetLoanInterval();

		return balance < step ? 0 :
			min(loaned_money, balance - balance % step);
	}
}

/**
 * Class that handles loan when AI bank balance becomes negative.
 */
class AIForceLoanAction extends TriggerAction
{
/* public */
	function GetName() { return "Force Loan";}

/* protected */
	function Execute()
	{
		if (CorporationUtils.month_income.value > this.stop_point) {
			Corporation.Get().StopLoanOperations();
			this.SelfRemove();
		}
		return AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount());
	}

	function IsReady()
	{
		return AICompany.GetBankBalance(AICompany.COMPANY_SELF) < 0 ?
			AICompany.GetLoanAmount() < AICompany.GetMaxLoanAmount() : false;
	}

/* private */
	/** Stop loan operations when month income exceed this value. */
	stop_point = 25000;
}
