/**
 * Information about Terron AI.
 */
class Terron extends AIInfo {
	function GetAuthor()      { return "svetovoi"; }
	function GetName()        { return "Terron"; }
	function GetShortName()   { return "TERR"; }
	function GetDescription() { return "Check the readme!"; }
	function GetVersion()     { return 209; }
	function MinVersionToLoad() { return 209; }
	function CanLoadFromVersion(version) { return 209 <= version && version <= 209;}
	function GetDate()        { return "2012-12-13"; }
	function CreateInstance() { return "Terron"; }
	function GetAPIVersion()  { return "1.3"; } 
	function GetSettings() {
		AddSetting({
			name = "BusModule",
			description = "Use buses",
			min_value = 0,
			max_value = 3,
			easy_value = 0,
			medium_value = 1,
			hard_value = 1,
			custom_value = 1,
			flags = 0
		});
		AddLabels(
			"BusModule", {
				_0 = "No",
				_1 = "Town-to-town transportation",
				_2 = "Passengers transit into docks or airports",
				_3 = "Mixed",
			}
		);

		AddSetting({
			name = "TruckModule",
			description = "Use trucks",
			min_value = 0,
			max_value = 3,
			easy_value = 1,
			medium_value = 2,
			hard_value = 3,
			custom_value = 3,
			flags = 0
		});
	    AddLabels(
			"TruckModule", {
				_0 = "No",
				_1 = "Simple \"greedy strategy\"",
				_2 = "Test \"Delivery Tree\" strategy",
				_3 = "Mixed",
			}
		);

		AddSetting({
			name = "max_road_route_length",
			description = "Max road routes length",
			min_value = 60,
			max_value = 130,
			easy_value = 60,
			medium_value = 95,
			hard_value = 125,
			custom_value = 130,
			flags = 0,
			step_size = 5
		}); 

		AddSetting({
			name = "PlaneModule",
			description = "Use planes",
			min_value = 0,
			max_value = 2,
			easy_value = 0,
			medium_value = 1,
			hard_value = 2,
			custom_value = 1,
			flags = 0
		});
		AddLabels(
			"PlaneModule", {
				_0 = "No",
				_1 = "Yes, but not as first transport type",
				_2 = "Yes",
			}
		);

		AddSetting({
			name = "max_air_route_length",
			description = "Max airlines length",
			min_value = 220,
			max_value = 450,
			easy_value = 250,
			medium_value = 320,
			hard_value = 390,
			custom_value = 390,
			flags = 0,
			step_size = 10
		});
		AddSetting({
			name = "use_small_airports",
			description = "Use small airports",
			easy_value = 1,
			medium_value = 1,
			hard_value = 0,
			custom_value = 0,
			flags = AICONFIG_BOOLEAN
		});
		AddSetting({
			name = "airport_base_maintenance_cost",
			description = "Airports maintenance cost",
			min_value = 0,
			max_value = 1,
			easy_value = 0,
			medium_value = 0,
			hard_value = 0,
			custom_value = 0,
			flags = 0
		});
		AddLabels(
			"airport_base_maintenance_cost", {
				_0 = "Default game value",
				_1 = "Av8 newGRF custom value",
			}
		);

		AddSetting({
			name = "ShipModule",
			description = "Use ships",
			min_value = 0,
			max_value = 2,
			easy_value = 1,
			medium_value = 1,
			hard_value = 2,
			custom_value = 2,
			flags = 0
		});
		AddLabels(
			"ShipModule", {
				_0 = "No",
				_1 = "Yes, but not as first transport type",
				_2 = "Yes",
			}
		);

		AddSetting({
			name = "max_water_route_length",
			description = "Max water routes length",
			min_value = 200,
			max_value = 400,
			easy_value = 200,
			medium_value = 260,
			hard_value = 320,
			custom_value = 320,
			flags = 0,
			step_size = 10
		});
		AddSetting({
			name = "use_slow_ships",
			description = "Use slow ships",
			easy_value = 1,
			medium_value = 0,
			hard_value = 0,
			custom_value = 0,
			flags = AICONFIG_BOOLEAN
		});

		AddSetting({
			name = "fund_town_buildings",
			description = "Use free money to fund new buildings in the towns with AI company statue",
			easy_value = 1,
			medium_value = 1,
			hard_value = 0,
			custom_value = 0,
			flags = AICONFIG_BOOLEAN
		});
	}
}

RegisterAI(Terron());
