/**
 * This is a placeholder for different "magic numbers" used to control AI, but
 *  not specific enough to put them into one of the setting classes.
 */
class MagicNumbers
{
	/**
	 * Defines how many "regions" AI can use(and even see) at big maps.
	 * "Region" is just 512x512 square.
	 * AI will use entire small(<= 512x512) maps. When it comes to
	 *  bigger maps AI just slices them into several smaller maps - regions and
	 *  operate independantly inside of each. Thus instead of playing on one
	 *  1024x1024 map AI actually plays on 2 - 4 independent 512x512 maps.
	 * User hardly can notice difference(when value > 3) while AI receives
	 *  performance advantage.
	 */
	static regions_to_play_count = 2;

	/**
	 * Defines how close two industries much be to each other to form
	 *  "heap node".
	 */
	static heap_node_radius = 36;

	/**
	 * Defines summary production of raw industries in supply nets to press for.
	 */
	static supply_net_target_raw_production_sum = 380;

	/**
	 * How many road networks AI can try to build "at the same time".
	 */
	static max_active_road_networks = 2;

	/**
	 * Min population for town to be considered worthy of own supply network.
	 */
	static min_town_pop_for_net_root = 420;
}
