require("files.nut");

/**
 * Terron AI. 
 */
class Terron extends AIController
{
/* public */
	/**
	 * Saves Terron AI data.
	 * @return table to save.
	 */ 
	function Save()
	{
		return {save_document = Terron.memento[0]};
	}

	/**
	 * Try to restore AI from the savegame data.
	 * @param data Stuff to load, result of Save().
	 */
	function Load(v, data)
	{
		this.save_data = data.rawget("save_document");
	}

	/** Starts the AI. */
	function Start()
	{
		AILog.Info("Hello, world!");
		/* Use the old save(if it exist) until new one will be created */
		Terron.memento[0] = this.save_data;

		/* Auto renew unwanted, we'll manage vehicles ourselves */
		AICompany.SetAutoRenewStatus(false);

		/* Must init settings first because other stuff depends on it */
		_ai_clock.Start();
		CorporationUtils.Init();
		Terron_Settings.Init();

		local is_game_loaded = (this.save_data != null);
		/* Time inside the "Load" function is limited, so we'll load here */
		if (is_game_loaded) {
			if (SaveLoadUtils.Load(this.save_data) == null) {
				AILog.Error("Loading failed. The AI will not start.");
				return;
			}
		}

		/* "Start" notification can simplify several tasks inside AI */
		AIStartedEvent.Fire(is_game_loaded);

		/* AI work noose */
		local date = AIDate.GetCurrentDate();
		for (local corp = Corporation.Get(); date = AIDate.GetCurrentDate();) {
			if (Terron.memento[1] == true) Terron.MakeMemento();
			if (date >= _ai_clock.next_run_date) _ai_clock.Run(date);
			corp.Work();
		}
	}

	/**
	 * Instruction to update AI's save data.
	 */
	static function UpdateMemento()
	{
		Terron.memento[1] = true;
	}

/* private */
	/** Current AI state prepared for fast game saving. */
	static memento = [null, true];

	/**
	 * Creates data to save.
	 */
	static function MakeMemento()
	{
		local to_save = [];
		/* Save settings data fisrt => will load it first too */
		AISettingsSaveEvent.Fire(to_save);
		AISaveEvent.Fire(to_save);
		Terron.memento[0] = SaveLoadUtils.Save(to_save, "root_array");
		Terron.memento[1] = false;
	}

	/**
	 * Loaded data that must be translated into AI objects,
	 *  or null for the new game.
	 */
	save_data = null;
}
