/**
 * Calculate the action's priority.
 * @param startup_cost Initial action cost
 *  (action can have several steps, this is cost of first).
 * @param full_cost Full action cost. Negative number mean "selling".
 * @param income Direct month income AI will begin to receive right after action.
 * @param future_income Possible month income AI can receive in future
 *  (if this action will be completed).
 * @return Number that indicates action's desireability for AI.
 */
/* static */ function ActionPriority::CalculatePriority(startup_cost, full_cost, income, future_income)
{
	/* Set max priority for "sell something" actions */
	if (full_cost < 0) return APriority.MAX;

	/*
	 * Set priority above average for the actions which make money,
	 * (or triggers money making mechanism).
	 * Example: Action that buy new truck.
	 */
	if (income > 0) {
		return full_cost != 0 ? (APriority.HALF + 10.0 * income / full_cost) : APriority.MAX; 
	}

	/* Income <= 0 and future_income <= 0. We don't want it */
	if (future_income <= 0) return APriority.BAD;

	/* Set priority below average for the actions not making instant money */
	// here is the place to improve
	local p = APriority.HALF - 10.0 * startup_cost / future_income;
	return p > APriority.BAD ? p : APriority.BAD;
}
