/**
 * Base class that provides triggers.
 * Such actions must be executed, as a reaction to a certain situation/condition
 */
class TriggerAction extends Terron_AbstractAction
{
/* public */
	function GetPriority()
	{
		return this.IsReady() ? APriority.MAX : APriority.BAD;
	}

/* protected */
	/**
	 * Check if this action is ready to be executed.
	 * @return true if game conditions demand to use this action, false else. 
	 */
	function IsReady();
}
