/**
 * Class that handles a action instance replacement inside the AI
 *  "to-do list" when the instance can't do its work for too long.
 */
class UniversalAction_SelfRemoveTask extends Terron_AbstractTask
{
/* public */
	/**
	 * Creates the task to shutdown the specified action.
	 * @param action Action to watch after.
	 * @param time_till_remove Time, defines how long action can try to do self.
	 */
	constructor(action, time_till_remove)
	{
		::Terron_AbstractTask.constructor(action.GetID());

		action.self_remove_sheduled = true;

		this.action = action;
		this.next_run_date = AIDate.GetCurrentDate() + time_till_remove;
		this.SetName("Self remove task for \"" + action.GetName() + "\"");
		_ai_clock.AddTask(this);
	}

	function Run(current_date)
	{
		this.action.SelfRemove();
	}

/* private */
	/** Action to shutdown */
	action = null;
}
