/* enums must be loaded first in order to be used everywhere */

enum NodeClass {
	NC_INDUSTRY
	NC_TOWN
	NC_TRANSIT
}

enum NodeTypeID {
	NT_TRANSIT_START = 124
	NT_TRANSIT_DROP = 125
	NT_PAX_TOWN = 126
	NT_RAW_TOWN = 127
	NT_MAXTYPES = 128
}

enum GameTime {
	/* General time intervals */
	DAY             = 1
	MONTH           = 30
	HALF_YEAR       = 182
	YEAR            = 365
	MONTHS_PER_YEAR = 12

	/* Service values */
	ENGINE_REVIEW_INTERVAL = 270
	SHEDULE_SIZE           = 2048
}

enum Ticks {
/* I choose medium "AI construction speed" game setting value for this */
// should be also good enough for slow (and of course fast/very fast)
// With "very slow" setting value AI will be, well, very slow...
	DAY = 37
	HALF_DAY = 18
}

enum EngineStat {
	ES_CAPACITY = 0
	ES_MAX_AGE = 1
	ES_MAX_SPEED = 2
	ES_PRICE = 3
	ES_RELIABILITY = 4
	ES_MONTH_RUNNING_COST = 5
	ES_DESIGN_YEAR = 6
	ES_AVG_PROFIT_DROP = 7
}

enum TransitType {
	TT_BUS
	TT_TRUCK
}

enum BasinType
{
	BT_LAKE
	BT_SEA
	BT_STRAIT
	BT_BAY
}

enum SeaLevelRecognition
{
	SL_LAND = 0
	SL_SEA_SHORE = 40
	SL_SEA = 60
	SL_OPEN_SEA = 80
}

enum ConstructionCommand
{
	CC_ROAD_X
	CC_ROAD_Y
	CC_ROAD_DEPOT
	CC_BUS_STATION
	CC_TRUCK_STATION
}
