//import("AILib.EventBase", "EventBase", 2);
require("local_lib_event.nut");

/** Base event interface */
class Terron_Event extends EventBase {};

/**
 * Event indicating AI "start".
 * Should indicate "failsafe start" - mean that everything crucial is already
 *  initialized.
 * @note Triggered after loading(if any) and settings up.
 */
class AIStartedEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnAIStarted";
}

/** Event to save settings objects. */
class AISettingsSaveEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnSettingsSave";
}

/** Event to save everything but settings objects. */
class AISaveEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnSave";
}

/** Event indicating that AI has nothing to do. */
class FreeTimeEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnFreeTime";
}

/** Event indicating that one of the AI parts has been closed. */
class TransportSystemClosedEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnTransportSystemClose";
}

/** Event indicating that one of the trade routes has been closed. */
class TradeRouteClosedEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnTradeRouteClose";
}

/** Indicates that (road) trade route dublicate needed */
class AdditionalRoadTradeWantedEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnAdditionalRoadTradeWanted";
}

/** Event indicating that road vehicle stuck in a jam. */
class RoadVehicleStuckEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnRoadVehicleStuck";
}

/** Event indicating that road vehicle must be sold (right now). */
class ForceSellRoadVehicleEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnForceSellRoadVehicle";
}

/**
 * Announce that a new "node" object can be used by AI.
 * @note Must be fired only once for each node.
 */
class NewNodeEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnNewNode";
}

/** Event to announce that new transit node wanted. */
class TransitWantedEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnTransitWanted";
}

/** Event to simplify transit income calculations. */
class TransitIncomeCalculatedEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnTransitIncomeCalculated";
}

/** Event indicating that transit station is closing. */
class TransitStationClosingEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnTransitStationClose";
}

/** Event indicating that all map region nodes announced. */
class RegionScanFinishedEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnRegionScanFinished";
}

/** not used */
class RoadTreeRootCloseEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnRoadTreeRootClose";
}

/** Event indicating that new road trade route has been created. */
class NewRoadTradeRouteEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnNewRoadTradeRoute";
}

/** Event indicating that new airport has been built. */
class NewAirportBuiltEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnNewAirport";
}

/** Event for planes reallocation instead of selling. */
class UsedPlaneAvailabeForFreeEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnFreeUsedPlane";
}

/** Event for force active department selection. */
class DepartmentRequestsPriorityEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnDepartmentPriorityRequest";
}

class AircraftEchoEvent extends Terron_Event
{
	/** Handler method name */
	static reaction_method_name = "OnAircraftEcho";
}
