/**
 * Class that handles time-depended updates of the some data.<p>
 * This class is all about access to the value that, after some time,
 *  becomes "obsolete" - must be recalculated and reset.<p>
 * This class makes value update when needed
 *  and don't make update when not needed.
 * From the outside we always receive valid value.<p>
 * It can be said that this class caches data access.<p>
 */
class Property extends Terron_AbstractTask
{
/* public */
	static function GetClassName()
	{
		return "Property";
	}

	/**
	 * Creates a new property.
	 * @param update_callback The function that must calculate new property value
	 *  when the old value becomes obsolete. Must take no params.
	 * @param update_delay Defines property value obsolete period.
	 */
	constructor(update_callback, update_delay)
	{
		::Terron_AbstractTask.constructor(null);
		this.update_callback = update_callback;
		this.update_delay = update_delay;
		this.next_run_date = -1000;
	}

	/**
	 * Remove this object from the game.
	 */
	function Destroy()
	{
		if (this.next_run_date > 0) _ai_clock.RemoveTask(this);
		this.update_callback = null;
	}

	/**
	 * Get the value of this property.
	 */
	function Get()
	{
		if (this.next_run_date <= 0) this.Update();
		return this.value;
	}

	function Run(current_date)
	{
		// this is hilarious
		this.next_run_date = -1000;

		/* though this is serious */
		/*
		 * We do not write:
		 *
		 *	this.next_run_date = -1000;
		 *	this.Update()
		 *
		 * in this function but insted keep Update in Get() with line:
		 * if (this.next_run_date <= 0) this.Update();
		 *
		 * with purpose to NOT run Update when actual data is not needed
		 */
		 /*
		  * btw [if...] increases Get function upkeep cost up to 25%,
		  * and another 20% since without [if..] we can just grab .value
		  * simple test showed 24, 17 and 14 ticks for 10k access iterations
		  * 24 - current code,
		  * 17 - .Get() without [if..] (suppose we'll move update into Run)
		  * 14 - direct .value access from the outside.
		  * but single Update call can easily exceed 10 ticks =>
		  *  by not calling it once for uniportant data we receive
		  *  10k "free" calls for other (important) data.
		  * I think this is good tradeoff,
		  *  and therefore Get() and Run() and Update() has current form.
		  */
	}

	/**
	 * Reset this property value(when update time has come).
	 */
	function Update()
	{
		this.value = this.update_callback();
		this.next_run_date = this.update_delay + AIDate.GetCurrentDate();
		_ai_clock.AddTask(this);
	}

	/**
	 * Reset this property value NOW.
	 */
	function ForceUpdate()
	{
		if (this.next_run_date > 0) _ai_clock.RemoveTask(this);
		this.Update();
	}

/* private */
	/** Some data this object must provides access to */
	value = null;

	/** Callback function to update value when needed */
	update_callback = null;

	/** Max time period while value can remain valid */
	update_delay = null;
}
