/**
 * A task that can be scheduled for one time or repeated execution.
 */
class Terron_Task extends Terron_AbstractTask
{
/* public */
	static function GetClassName()
	{
		return "Terron_Task";
	}

	/**
	 * Creates a new task.
	 * @param first_run_date Date for first task run.
	 * @param period Execution period (e.g. 17 mean once in 17 days).
	 */
	constructor(first_run_date, period)
	{
		::Terron_AbstractTask.constructor(null);
		this.next_run_date = first_run_date;
		this.period = period;
		_ai_clock.AddTask(this);
	}

	function Run(current_date)
	{
		this.Execute();
		if (this.period > 0) {
			this.next_run_date = current_date + this.period;
			_ai_clock.AddTask(this);
		} 
	}

/* protected */
	/**
	 * Period in days for repeating tasks.
	 * Negative and zero value mean one time call, without repeating. 
	 */
	period = null;

	/**
	 * This is the task itself.
	 * @note Should be implemented be subclasses, of course. 
	 */
	function Execute();
}
