/**
 * Class that handles transport nodes integration(linking) into global AI scope.
 */
class Linker extends Terron_Object
{
	/**
	 * Properly set up new transport node's links colors.
	 */
	function RescaleNewNodeLinks(transport_node)
	{
		if (transport_node.node.type.raw_consumption) {
			Linker.HandleRawConsumer(transport_node);
			return;
		}

		local paths = Linker.GetPathToRawConsumer(transport_node);
		foreach (dummy_id, path in paths) {
			if (path[path.len() - 1].GetNode().GetType().raw_consumption) {
				Linker.HandleRawConsumer(path[path.len() - 1]);
			}
		}
	}

/* private */
	/**
	 * private
	 */
	function GetPathFromRawConsumer(node)
	{
		if (!node.CanBeRoot()) return [];
		if (node.GetNode().GetType().raw_production) return [[node]];

		local result = [];
		local global = GlobalTransportMap.Get();
		foreach (to_node_id, dummy in node.links_out) {
			local next = global.GetTransportNodeByID(to_node_id);
			if (next.IsWeak()) continue;
			if (next.node.type.raw_consumption) {
				result.append([node, next]);
				continue;
			}

			local forward_path = Linker.GetPathFromRawConsumer(next);
			if (forward_path.len() == 0) continue;
			foreach (i, path in forward_path) {
				if (path.len() == 0) assert(null);
				if (!path[path.len() - 1].node.type.raw_production) continue;
				result.append([node]);
				result[result.len() - 1].extend(path);
			}
		}
		return result;
	}

	/**
	 * private
	 */
	function GetPathToRawProducer(node)
	{
		if (!node.CanBeRoot()) return [];
		if (node.node.type.raw_production) return [[node]];

		local result = [];
		local global = GlobalTransportMap.Get();
		foreach (from_node_id, link in node.links_in) {
			local next = global.GetTransportNodeByID(from_node_id);
			if (next.IsWeak()) continue;
			if (next.GetNode().GetType().raw_consumption && next.CanBeRoot()) {
				result.append([node, next]);
				continue;
			}

			local forward_path = Linker.GetPathToRawProducer(next);
			if (forward_path.len() == 0) continue;
			foreach (i, path in forward_path) {
				if (path.len() == 0) assert(null);
				if (!path[path.len() - 1].node.type.raw_production) continue;
				result.append([node]);
				result[result.len() - 1].extend(path);
			}
		}
		return result;
	}

	/**
	 * private
	 */
	function GetPathToRawConsumer(transport_node)
	{
		if (!transport_node.CanBeRoot()) return [];
		if (transport_node.GetNode().GetType().raw_consumption) {
			return [[transport_node]];
		}

		local result = [];
		local global = GlobalTransportMap.Get();
		foreach (to_node_id, dummy in transport_node.links_out) {
			local next = global.GetTransportNodeByID(to_node_id);
			if (next.GetNode().GetType().raw_production) continue;
			if (next.IsWeak()) continue;

			local forward_path = Linker.GetPathToRawConsumer(next);
			if (forward_path.len() == 0) continue;
			foreach (i, path in forward_path) {
				if (!path[path.len() - 1].GetNode().GetType().raw_consumption) {
					continue;
				}
				result.append([transport_node]);
				result[result.len() - 1].extend(path);
			}
		}
		return result;
	}

	/**
	 * private
	 */
	function HandleRawConsumer(transport_node)
	{
		local paths = Linker.GetPathToRawProducer(transport_node);
		foreach (dummy_id, path in paths) {
			local n = path.len();
			foreach (j, node in path) {
				if (j >= n - 1) break;
				local next_node = path[j + 1];
				local link = node.links_in[next_node.GetID()];
				if (link.color == LinkColor.LC_YELLOW) continue;
				if (link.color == LinkColor.LC_GREEN) continue;
				if (j < n - 2) {
					link.SetColor(LinkColor.LC_RED);
				} else {
					link.SetColor(LinkColor.LC_GREEN);
				}
			}
		}

		local paths = Linker.GetPathFromRawConsumer(transport_node);
		foreach (dummy_id, path in paths) {
			local color = (path[1].node.GetTypeID() == transport_node.node.GetTypeID()) ?
				LinkColor.LC_GREEN : LinkColor.LC_RED;
			path[0].links_out[path[1].GetID()].SetColor(color);
			for (local j = 1; j < path.len() - 1; j++) {
				local link = path[j].links_out[path[j + 1].GetID()];
				if (link.color == LinkColor.LC_YELLOW) continue;
				if (link.color == LinkColor.LC_GREEN) continue;
				link.SetColor(LinkColor.LC_RED);
			}
		}
	}
}
