/**
 * Class that handles industries as nodes.
 */
class IndustryNode extends Node
{
/* public */
	static function GetClassName()
	{
		return "IndustryNode";
	}

	static function Restore(memento)
	{
		local type = TransportSchema.Get().node_types[memento.type_id];
		local restored = IndustryNode(memento.i_id, type);
		restored.stations = memento.stations;
		return restored;
	}

	/** Industry ID. */
	</ must_save = true />
	i_id = null;

	constructor(industry_id, industry_type)
	{
		local name = AIIndustry.GetName(industry_id);
		local location = AIIndustry.GetLocation(industry_id); 
		::Node.constructor(industry_id, industry_type, name, location);

		this.i_id = industry_id;
		if (AIIndustry.IsBuiltOnWater(industry_id)) this.is_built_on_water = true;
	}

	function AITileList_NodeAccepting(r, c)
	{
		local list = AITileList_IndustryAccepting(this.i_id, r);
		list.Valuate(AITile.GetCargoAcceptance, c, 1, 1, r);
		list.RemoveBelowValue(8);
		return list;
	}

	function AITileList_NodeProducing(r, ...)
	{
		return AITileList_IndustryProducing(this.i_id, r);
	}

	/**
	 * Get the ID of the underlying industry.
	 */
	function GetIndustryID()
	{
		return this.i_id;
	}

	function IsAccepting(c)
	{
		return ::Node.IsAccepting(c) &&
			AITile.GetCargoAcceptance(this.location, c, 1, 1, 1) >= 8;
	}

	/**
	 * not used
	 */
	function IsAcceptingRightNow(c)
	{
		return IsAccepting(c);
	}

	function IsProducing(c)
	{
		return ::Node.IsProducing(c) &&
			AIIndustry.GetLastMonthProduction(this.i_id, c) >= 0;
	}

	function GetLastMonthProduction(c)
	{
		return AIIndustry.GetLastMonthProduction(this.i_id, c);
	}

	function GetLastMonthTransported(c)
	{
		return max(0, AIIndustry.GetLastMonthTransported(this.i_id, c));
	}

	function GetAmountOfOpponentsStationsAround()
	{
		local n = AIIndustry.GetAmountOfStationsAround(this.node_id);
		// a bit inaccurate
		return max(n - this.stations.Count(), 0);
	}
}

IndustryNode.setattributes("type_id", {must_save = true});
Terron_ClassTable.RegisterClass(IndustryNode);
