/**
 * Interface for node factories.
 */
class NodeFactory extends Terron_Object
{
	constructor()
	{
		::Terron_Object.constructor(null);
	}

	/**
	 * Each factory must handle only one nodes "class" - e.g. industry nodes, or
	 *  town nodes, or maybe some specific transit nodes.
	 * To avoid conflicts class ids should be enlisted in enum NodeClass.
	 */
	function GetCorrespondingNodeClassID();

	/**
	 * Get information about nodes that the factory can produce.
	 * @return Node type primitives - will be used to form a solid representaion
	 *  of the transport possibilities between different nodes - as a table.
	 */
	function GetPrimitiveTypes();

	/**
	 * Create nodes representation of objects currently existing in game.
	 * @param full_node_types_table Table with node types allowed for AI.
	 *  If factory can create nodes of a type 'X', but there is no 'X' in this
	 *  table => factory must not create nodes of the type 'X'.
	 * @return Table with created nodes.
	 */
	function CreateNodes(full_node_types_table);
}

/*
 * It's obvious that approach with multiple entities(nodes)
 *  created to represent and give access to same game object produce
 *  a lot of problems - code (and memory) dublication, synchronization problems,
 *  some save/load issues maybe - it's just inpractical.
 * So, instead of having separate town node instances to work for with buses,
 *  trucks or planes there should be only one instace for each town, no matter
 *  who will use it.
 * This small table exists as part of node factories approach to
 *  provide clear way to recognize all nodes available to AI at moment(though
 *  it's intended to be used only once shortly after AI start), and receive
 *  single node object for each single game entity that considered important.
 *  "Clear" mean clear interface to incorporate nodes into AI (mean we'll
 *   not have to iterate TownList in the middle of code that actually not
 *   supposed to know about TownList, or IndustryList).
 */
/**
 * Special table to plug-in all node factories available for AI.
 */
node_classes_mount_point <- {
/* public */
	/**
	 * Use this to define entire (raw)node classes(like towns/industries).
	 */
	/* static */ function InjectNodeClassImplementation(class_nodes_factory)
	{
		local id = class_nodes_factory.GetCorrespondingNodeClassID();
		// each node class must have only one implementation
		if (id in node_classes_mount_point.factories) assert(null); 
		node_classes_mount_point.factories[id] <- class_nodes_factory;
	}

/* private */
	/** List of node factories */
	/* static */ factories = {}
}
