/**
 * Class that handles collection of objects as single node.
 */
class HeapNode extends Node
{
/* public */
	cargo_ids_to_feed = null;

	static function GetClassName()
	{
		return "HeapNode";
	}

	static function Restore(memento)
	{
		local c_ids = {};
		foreach (dummy_id, c in memento.c_ids) {
			c_ids[c] <- c;
		}

		local restored = HeapNode(memento.central_node, c_ids,
			memento.transport_types, memento.secondary_nodes);

		restored.stations = memento.stations;
		return restored;
	}

	</ must_save = true />
	central_node = null;

	secondary_nodes = null;

	/**
	 * Table with allowed methods of cargo delivery <b>to</b> the node's station.
	 */
	transport_types_allowed = null;

	/**
	 * Creates a heap node.
	 */
	constructor(central_node, c_ids, transit_transport_types_allowed, secondary_nodes)
	{
		local name = "->" + central_node.GetName() + "<-";
		::Node.constructor(central_node.node_id, central_node.type, name, central_node.location);

		this.central_node = central_node;

		this.secondary_nodes = {};
		foreach (dummy_id, node in secondary_nodes) {
			this.secondary_nodes[node.GetID()] <- node;
		}

		this.cargo_ids_to_feed = {};
		foreach (c, dummy in c_ids) {
			this.cargo_ids_to_feed[c] <- {stations = {}, additional_transit_income = 0};
		}

		this.transport_types_allowed = {};
		foreach (dummy, type in transit_transport_types_allowed) {
			this.transport_types_allowed[type] <- type;
		}

		//Terron.UpdateMemento();
		TransitIncomeCalculatedEvent.AddListener(this);
	}

	function GetMemento()
	{
		local memento = ::Node.GetMemento();
		memento.c_ids <- [];
		foreach (c, dummy in this.cargo_ids_to_feed) {
			memento.c_ids.append(c);
		}
		memento.secondary_nodes <- CodeUtils.TableToArray(this.secondary_nodes);
		memento.transport_types <- CodeUtils.TableToArray(this.transport_types_allowed);
		return memento;
	}

	function AITileList_NodeAccepting(r, c)
	{
		return this.central_node.AITileList_NodeProducing(r, c);
	}

	function AITileList_NodeProducing(r, ...)
	{
		switch (vargc) {
			case 0 :
				return this.central_node.AITileList_NodeProducing(r);
			case 1 :
				return this.central_node.AITileList_NodeProducing(r, vargv[0]);
			case 2 :
				return this.central_node.AITileList_NodeProducing(r, vargv[0], vargv[1]);
		}
	}

	function GetLastMonthProduction(c)
	{
		local result = this.central_node.GetLastMonthProduction(c);
		foreach (id, node in this.secondary_nodes) {
			result += node.GetLastMonthProduction(c);
		}

		return result;
	}

	function GetLastMonthTransported(c)
	{
		local result = this.central_node.GetLastMonthTransported(c);
		foreach (id, node in this.secondary_nodes) {
			result += node.GetLastMonthTransported(c);
		}

		return result;
	}

	function GetAmountOfOpponentsStationsAround()
	{
		return this.central_node.GetAmountOfOpponentsStationsAround();
	}

	function GetAdditionalTransitIncome(c)
	{
		return c in this.cargo_ids_to_feed ?
			this.cargo_ids_to_feed[c].additional_transit_income : 0;
	}

	function CreateSubRoutes(transport_node, station_id, cargo_id)
	{
		if (!(cargo_id in this.cargo_ids_to_feed)) return;

		this.cargo_ids_to_feed[cargo_id].additional_transit_income = 250;

		local politics = HeapSupportTransportPolitics(transport_node);
		foreach (dummy_id, node in this.secondary_nodes) {
			NodesRepository.Get().AddNode(node);
			politics.EnableTransportNode(node);
		}
	}

	/**
	 * Update information about income from transfer operations.
	 * @param data Table with station_id and cargo_income fields.
	 */
	function OnTransitIncomeCalculated(data)
	{
		if (!(data.cargo_id in this.cargo_ids_to_feed)) return;

		local i = 100 + data.cargo_income;
		local info = this.cargo_ids_to_feed[data.cargo_id];
		foreach (dummy_station_class_name, class_stations in this.stations.stations) {
			foreach (dummy_runtime_id, s in class_stations) {
				if (s.GetStationID() == data.station_id) {
					info.additional_transit_income = i;
					return;
				}
			}
		}
	}

/* protected */
	function doGetFreeCargoProduction(c)
	{
		local result = this.central_node.GetFreeProduction(c);
		local closed_nodes = [];
		foreach (id, node in this.secondary_nodes) {
			if (!node.IsValid()) {
				closed_nodes.append(node.GetID());
			} else if (node.GetAllStations().stations_count == 0) {
				result += node.GetFreeProduction(c);
			}
		}

		foreach (dummy, node_runtime_id in closed_nodes) {
			delete this.secondary_nodes[node_runtime_id];
		}

		return result;
	}
}

Terron_ClassTable.RegisterClass(HeapNode);
