class SupplyNet extends SupplyContingent
{
/* public */
	static function GetClassName()
	{
		return "SupplyNet";
	}

	static function Create(transport_node)
	{
		return transport_node == null ? null : SupplyNet(transport_node);
	}

	function Clear()
	{
		if (this.links != null) {
			this.links.clear();
			this.links = null;
		}

		if (this.levels != null) {
			foreach (level, level_nodes in this.levels) {
				foreach (node_id, links in level_nodes) {
					links.clear();
				}
				level_nodes.clear();
			}

			this.levels.clear();
			this.levels = null;
		}

		this.name = "CLEARED " + this.name;
	}

	function Clone()
	{
		local result = this.doCloning(SupplyNet(null));
		result.SetLinkValues();
		return result;
	}

	function PrintInfo()
	{
		local global = GlobalTransportMap.Get();
		foreach (level_id, level_nodes in this.levels) {
			CodeUtils.Log("/-------- Level " + level_id + " --------/", 2);
			foreach (node_id, links in level_nodes) {
				local node = global.GetTransportNodeByID(node_id);
				CodeUtils.Log(node.GetName(), 2);
			}
		}
	}

/* protected */
	constructor(root_transport_node)
	{
		::SupplyContingent.constructor(root_transport_node);

		/* Cloning stops here */
		if (root_transport_node == null) return;

		this.SetLinkValues();

		/*local net_forming_links = SupplyNetBuilder.ExcreteMaxNet(this, 3, {});
		foreach (link_id, link in net_forming_links) {
			foreach (dummy_id, route in link.routes) {
				if (route.GetStart().type.raw_production) {
					AILog.Info("     : " + route.GetName());
				} else {
					AILog.Info("     : " + route.GetName());
				}
			}
		}
		assert(null);*/
	}

/* private */
	function SetLinkValues()
	{
		foreach (level, level_nodes in this.levels) {
			foreach (dummy_node_id, links in level_nodes) {
				/*local global = GlobalTransportMap.Get();
				local xnode = global.GetTransportNodeByID(dummy_node_id);
				AILog.Info(xnode.GetName());*/
				foreach (id, link_info in links) {
					local ci = 0, value = 1;
					foreach (dummy_id, route in link_info.link.routes) {
						route.doGetEngine()
						ci += route.GetNormalCargoIncome();
						local p = (route.GetFreeProduction()).tofloat();
						if (route.IsCompletelyUpgraded()) {
							p = 2 * route.GetStart().GetLastMonthProduction(route.GetCargoID());
						}
						local k = (p < 30.0 ? 900.0 : p * p) / route.length;
						if (value < k) value = k;
					}

					links[id].value <- (ci > 0) ?
						(value * ci) / link_info.link.routes.len() : 0;

					/*local ynode = global.GetTransportNodeByID(link_info.link.from_id);
					AILog.Info("         " + ynode.GetName() + ": " + links[id].value);*/
				}
			}
		}
	}
}
