/**
 * Class that describes what/where/from AI can transport.
 */
class TransportSchema extends Terron_Settings
{
/* public */
	static function GetClassName()
	{
		return "TransportSchema";
	}

	static function Restore(memento)
	{
		return TransportSchema();
	}

	/**
	 * Check if given shipment considered as "helper".
	 */
	static function IsAuxShipment(from_type, to_type)
	{
		return from_type.type_id in to_type.helpers;
	}

	/**
	 * Get array with cargo IDs shipment map.
	 */
	function GetShipmentsList(from_node_type_id, to_node_type_id)
	{
		return this.supply_map[from_node_type_id][to_node_type_id];
	}

	/** Map(key - type ID, value - type itself) with all node types. */
	node_types = null;

	production_supply_cargo_ids = null;

/* protected */
	/**
	 * Recognize available node types and build the entire transport schema.
	 */
	constructor()
	{
		::Terron_Settings.constructor();
		/* Must rebuild transport schema each time, so don't need to save it */
		AISettingsSaveEvent.RemoveListener(this);

		CodeUtils.Log("Generating cargo transport map...", 2);
		local tick = AIController.GetTick();

		CodeUtils.Log("...generating node type primitives...", 1);
		local primitive_type_map = {};
		foreach (dummy_id, factory in node_classes_mount_point.factories) { 
			foreach (id, type in factory.GetPrimitiveTypes()) {
				// each node type ID must be unique
				if (id in primitive_type_map) assert(null);
				primitive_type_map[id] <- type;
			}
		}

		CodeUtils.Log("...generating node types...", 1);
		this.node_types = {};
		foreach (id, primitive in primitive_type_map) { 
			this.node_types[id] <- NodeType(primitive, primitive_type_map);
		}
		foreach (id, type in this.node_types) {
			type.BuildSupplyTree(this.node_types);
			type.recipes = SuperRecipe(type);
			type.recipes.Print();
			type.PrintInfo(this.node_types);
			//type.PrintSupplyTree(this.node_types, 1);
			CodeUtils.Log("/*--------------------------------------------*/", 1);
		}

		CodeUtils.Log("Generating fast-access-cross-type supply map...", 1);
		this.CreateSupplyMap();
		CodeUtils.Log("... supply map completed", 1);

		this.production_supply_cargo_ids = {};
		foreach (c, dummy in AICargoList()) {
			local label = AICargo.GetCargoLabel(c);
			if (label.len() >= 2 && label.slice(2) == "SP") {
				this.production_supply_cargo_ids[c] <- c;
			}
		}
 
		/*foreach (i, i_type in this.node_types) {
			foreach (j, j_type in this.node_types) {
				local shipments_from = this.GetShipmentsList(i, j);
				if (shipments_from.len() > 0) {
				} else {
					local shipments_into = this.GetShipmentsList(j, i);
					if (shipments_into.len() > 0) {
					}
				}
			}
		}*/

		tick = (AIController.GetTick() - tick);
		CodeUtils.Log("... transport map complete, ticks:" + tick, 2);
	}

	/**
	 * Table which describes "what supplies what".
	 */
	supply_map = null;

	/**
	 * Create persistent object for fast access to "what supplies what" data.
	 */
	function CreateSupplyMap()
	{
		this.supply_map = {};
		foreach (from_type_id, from_type in this.node_types) {
			this.supply_map[from_type_id] <- {};
			foreach (to_type_id, to_type in this.node_types) {
				local cargo_ids = [];
				if (from_type_id in to_type.supply_tree.tree) {
					cargo_ids = to_type.supply_tree.tree[from_type_id].cargos;
				} else if (from_type_id in to_type.helpers) {
					cargo_ids = to_type.helpers[from_type_id];
				}
				this.supply_map[from_type_id][to_type_id] <- clone cargo_ids;
			}
		}
	}
}

Terron_ClassTable.RegisterClass(TransportSchema);
