/**
 * Class that represents airport terminal.
 * Actually entire airport is one big terminal.
 */
class AirportTerminal extends Station_LoadingTerminal
{
/* public */
	static function GetClassName()
	{
		return "AirportTerminal";
	}

	static function Restore(memento)
	{
		return AirportTerminal(memento.station_id, memento.cargo_id);
	}

	constructor(station_id, cargo_id)
	{
		::Station_LoadingTerminal.constructor(station_id, cargo_id);

		this.location = AIStation.GetLocation(station_id);
		this.airport_type = AIAirport.GetAirportType(this.location);
		this.max_frequency = AirConstants.airports_arrival_requency[airport_type];
		this.max_loading_planes = 0;
		switch (airport_type) {
			case AIAirport.AT_LARGE:         this.max_loading_planes = 2; break;
			case AIAirport.AT_SMALL:         this.max_loading_planes = 2; break;
			case AIAirport.AT_METROPOLITAN:  this.max_loading_planes = 3; break;
			case AIAirport.AT_INTERNATIONAL: this.max_loading_planes = 3; break;
			case AIAirport.AT_COMMUTER:      this.max_loading_planes = 2; break;
			case AIAirport.AT_INTERCON:      this.max_loading_planes = 4; break;
		}
	}

	function GetMemento()
	{
		return {station_id = this.station_id, cargo_id = this.cargo_id};
	}

	/**
	 * Get this airport type.
	 */
	function GetAirportType()
	{
		return this.airport_type;
	}

/* protected */
	function GetLoadingVehicles()
	{
		local v_list = AIVehicleList_Station(this.station_id);

		v_list.Valuate(AIVehicle.GetState);
		v_list.KeepValue(AIVehicle.VS_AT_STATION);
 
		local f = function(v) {
			return AIOrder.GetOrderDestination(v, AIOrder.ResolveOrderPosition(v, AIOrder.ORDER_CURRENT));
		}
		v_list.Valuate(f);
		v_list.KeepValue(this.location);

		v_list.Valuate(AIVehicle.GetCapacity, this.cargo_id);
		v_list.RemoveValue(0);

		return v_list.Count();
	}

	function GetMaxLoadingVehicles()
	{
		return this.max_loading_planes;
	}

	function GetMaxFrequency()
	{
		return this.max_frequency;
	}

/* private */
	/** The airport type. */
	airport_type = null;

	/** The airport location. */
	location = null;

	/** Max allowed planes arrival frequency for the terminal. */
	max_frequency = null;

	/** Max amount of simultaneously loading planes. */
	max_loading_planes = null;
}

Terron_ClassTable.RegisterClass(AirportTerminal);
