/**
 * Class that handles bus/truck stations upgrading.
 */
class AIExpandRoadStationAction extends TriggerAction
{
/* public */
	constructor(road_station_terminal)
	{
		// allow only step-by-step upgrades
		// If new action instance will be created while previous isn't done,
		// the new one just replace the old one in the actions container
		::Terron_Object.constructor(road_station_terminal.GetID());
		this.road_terminal = road_station_terminal;
	}

	function GetName()
	{
		return "Expanding: \"" + this.road_terminal.GetName() + "\" (road)";
	}

	function Try()
	{
		local terminal = this.road_terminal;

		this.SelfRemove();

		if ((!terminal.UnloadOnly()) && terminal.GetCargoID() == CorporationUtils.pass_cargo_id.value) {
			/* Do not proceed if company rating is too low in the station's town */
			local town = AIStation.GetNearestTown(terminal.station_id);
			local rating = AITown.GetRating(town, AICompany.COMPANY_SELF);
			if (rating == AITown.TOWN_RATING_NONE) rating = AITown.TOWN_RATING_VERY_GOOD;
			if (rating <= AITown.TOWN_RATING_POOR) {
				CodeUtils.Log("Can't expand station, locals are angry", 2);
				return -1;
			}
		}

		AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount());

		local v_type = terminal.station_type == AIStation.STATION_BUS_STOP ?
			AIRoad.ROADVEHTYPE_BUS : AIRoad.ROADVEHTYPE_TRUCK;
		local expansion_tile = terminal.core.drive_through ?
			IndustryStationBuilder.ExpandDriveThroughStation(terminal, v_type) :
			IndustryStationBuilder.ExpandNormalRoadStation(terminal, v_type);
		if (expansion_tile >= 0) {
			terminal.core.tiles.append(expansion_tile);
			terminal.core.failed_upgrades = 0;
			Terron.UpdateMemento();
			return 0;
		}

		if (this.retry) {
			AIController.Sleep(40);
			this.retry = false;
			return this.Try();
		}

		terminal.core.failed_upgrades++;
		return -1;
	}

/* protected */
	function IsReady()
	{
		local balance = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
		local free_loan = AICompany.GetMaxLoanAmount() - AICompany.GetLoanAmount();
		return (balance + free_loan) > 10000;
	}

/* private */
	/** Retry upgrade if failed */
	retry = true;

	/** The terminal to upgrade */
	road_terminal = null;
}
