/**
 * Class that provides interface for construction and later usage of
 *  road stations based on pre-designed templates.
 * @note After successfull construction each instance should correspond
 *  to one and only one station (which is described by this instance)
 */
class AbstractRoadStationPlan extends Terron_SaveableObject
{
/* public */
	static function GetClassName()
	{
		return "AbstractRoadStationPlan";
	}

	/**
	 * AbstractRoadStationPlan constructor.
	 */
	constructor()
	{
		::Terron_SaveableObject.constructor(null);

		this.cargo_load_terminals = [];
		this.cargo_drop_terminals = [];
	}

	/**
	 * Get station step-by-step construction instruction.
	 */
	function GetConstructionPlan();

	/**
	 * Get table with cargo load terminals for the station.
	 */
	function GetLoadingTerminals()
	{
		return this.cargo_load_terminals;
	}

	/**
	 * Get table with cargo drop terminals for the station.
	 */
	function GetCargoDropTerminals()
	{
		return this.cargo_drop_terminals;
	}

	/**
	 * Create a road station based on results of the build plan execution.
	 * @param build_result_info Result of the build plan(from the
	 *   GetConstructionPlan() function) execution.
	 * @return An instance of the RoadStation class.
	 */
	function MakeRoadStation(build_result_info);

/* protected */
	/**
	 * Should store results of the successfull station construction attempt.
	 */
	build_result_info = null;

	/**
	 * Array with cargo drop terminals.
	 */
	</ must_save = true />
	cargo_drop_terminals = null;

	/**
	 * Array with cargo load terminals.
	 */
	</ must_save = true />
	cargo_load_terminals = null;
}
