class FreeStationPlan extends AbstractRoadStationPlan
{
/* public */
	static function GetClassName()
	{
		return "FreeStationPlan";
	}

	static function Restore(memento)
	{
		local result = FreeStationPlan();
		result.cargo_drop_terminals = memento.cargo_drop_terminals;
		result.cargo_load_terminals = memento.cargo_load_terminals;
		return result;
	}

	static function MakePaxAndMailStationPlan(station_id, station_type, c)
	{
		local new_station_plan = FreeStationPlan();

		local tiles = AITileList_StationType(station_id, station_type);

		new_station_plan.cargo_load_terminals.append(
			RoadStation_LoadingTerminal(station_id, c, tiles)
		);

		local pass = CorporationUtils.pass_cargo_id.value;
		local mail = CorporationUtils.mail_cargo_id.value;
		if (c != mail && c != pass) return;

		new_station_plan.cargo_load_terminals.append(
			c == mail ?
				RoadStation_LoadingTerminal(station_id, pass, []) :
				RoadStation_LoadingTerminal(station_id, mail, [])
		);
		return new_station_plan;
	}

	static function MakeLoadStationPlan(station_id, station_type, c)
	{
		local new_station_plan = FreeStationPlan();

		local tiles = AITileList_StationType(station_id, station_type);
		new_station_plan.cargo_load_terminals.append(
			RoadStation_LoadingTerminal(station_id, c, tiles)
		);

		return new_station_plan;
	}

	static function MakeCargoDropStationPlan(station_id, station_type, c_list)
	{
		local new_station_plan = FreeStationPlan();

		local tiles = AITileList_StationType(station_id, station_type);
		local main_terminal = RoadStation_CargoDropTerminal(station_id, c_list, tiles);
		new_station_plan.cargo_drop_terminals.append(main_terminal);

		return new_station_plan;
	}

	constructor()
	{
		::AbstractRoadStationPlan.constructor();
	}

	function GetConstructionPlan()
	{
		return null;
	}

	function GetName()
	{
		return "StationPlan#" + this.GetID();
	}
}

Terron_ClassTable.RegisterClass(FreeStationPlan);
