/**
 * Class that organizes construction of road transit station according to one of
 *  the random templates available.
 */
class RandomTransitStationPlan extends AbstractRoadStationPlan
{
/* public */
	static function GetClassName()
	{
		return "RandomTransitStationPlan";
	}

	static function Restore(memento)
	{
		local result = RandomTransitStationPlan();
		result.cargo_drop_terminals = memento.cargo_drop_terminals;
		result.cargo_load_terminals = memento.cargo_load_terminals;
		return result;
	}

	/**
	 * RandomTransitStationPlan constructor.
	 */
	constructor()
	{
		::AbstractRoadStationPlan.constructor();
	}

	function GetConstructionPlan()
	{
		local dx = AIMap.GetTileIndex(1, 0);
		local dy = AIMap.GetTileIndex(0, 1);

		local rnd = AIBase.RandRange(6);
		switch (rnd) {
			case 0 :
			case 1 :
			case 2 :
			case 3 :
			case 4 :
				return RoadSiteConstructionPlan([
					RoadSiteConstructionCommand.ROAD_X(1, 0, 1),
					RoadSiteConstructionCommand.ROAD_X(1, 1, 1),
					RoadSiteConstructionCommand.ROAD_X(0, 2, 1),
					RoadSiteConstructionCommand.ROAD_X(0, 3, 1),
					RoadSiteConstructionCommand.ROAD_X(0, 4, 2),
					RoadSiteConstructionCommand.ROAD_Y(0, 2, 2),
					RoadSiteConstructionCommand.ROAD_Y(3, 0, 1),
					RoadSiteConstructionCommand.ROAD_Y(1, 0, 1),
					RoadSiteConstructionCommand.ROAD_Y(2, 2, 2),
					RoadSiteConstructionCommand.DEPOT(0, 1, dy),
					RoadSiteConstructionCommand.DEPOT(3, 2, -dy),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(2, 1, dx),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(2, 0, dx),
					RoadSiteConstructionCommand.TRUCK_DROP_TERMINAL(1, 2, dx),
					RoadSiteConstructionCommand.TRUCK_DROP_TERMINAL(1, 3, dx),
				]);
			/*case 4 :
				return RoadSiteConstructionPlan([
					RoadSiteConstructionCommand.ROAD_X(0, 0, 3),
					RoadSiteConstructionCommand.ROAD_X(0, 3, 3),

					RoadSiteConstructionCommand.TRUCK_DROP_TERMINAL(1, 1, -dy),
					RoadSiteConstructionCommand.TRUCK_DROP_TERMINAL(0, 1, -dy),
					RoadSiteConstructionCommand.TRUCK_DROP_TERMINAL(2, 1, -dy),
					RoadSiteConstructionCommand.DEPOT(3, 1, -dy),

					//RoadSiteConstructionCommand.DEPOT(0, 2, dy),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(1, 2, dy),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(2, 2, dy),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(3, 2, dy),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(0, 2, dy),
				]);*/
			case 5 :
				return RoadSiteConstructionPlan([
					RoadSiteConstructionCommand.ROAD_Y(0, 0, 2),
					RoadSiteConstructionCommand.ROAD_Y(3, 0, 2),
					RoadSiteConstructionCommand.DEPOT(2, 1, dx),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(1, 0, -dx),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(1, 1, -dx),
					RoadSiteConstructionCommand.TRUCK_LOAD_TERMINAL(1, 2, -dx),
					RoadSiteConstructionCommand.TRUCK_DROP_TERMINAL(2, 0, dx),
					RoadSiteConstructionCommand.TRUCK_DROP_TERMINAL(2, 2, dx),
				]);
		}
	}

	function MakeRoadStation(build_result_info, c, node_id, node_type_id)
	{
		this.build_result_info = build_result_info;

		local id = build_result_info.station_id;

		local load_tiles = build_result_info.cargo_load_terminal_tiles;
		local load_terminal = RoadStation_LoadingTerminal(id, c, load_tiles);
		this.cargo_load_terminals.append(load_terminal);

		local drop_tiles = build_result_info.cargo_drop_terminal_tiles;
		local drop_terminal = RoadStation_CargoDropTerminal(id, {[c] = c}, drop_tiles);
		this.cargo_drop_terminals.append(drop_terminal);

		local result = RoadStation(id, 0, node_id, node_type_id, this);
		foreach (dummy, terminal in result.station_plan.GetLoadingTerminals()) {
			terminal.core.max_upgrades_allowed = terminal.core.tiles.len() + 2;
		}
		return result;
	}
}

Terron_ClassTable.RegisterClass(RandomTransitStationPlan);
