RoadSiteConstructionCommand <- {
/* public */
	x = 0,
	y = 0,
	code = -1,
	extension = null,

	/* static */ function ROAD_X(start_x, start_y, len)
	{
		local new_command = clone ::RoadSiteConstructionCommand;
		new_command.x = start_x;
		new_command.y = start_y;
		new_command.code = ConstructionCommand.CC_ROAD_X;
		new_command.extension = len;
		return new_command;
	}

	/* static */ function ROAD_Y(start_x, start_y, len)
	{
		local new_command = clone ::RoadSiteConstructionCommand;
		new_command.x = start_x;
		new_command.y = start_y;
		new_command.code = ConstructionCommand.CC_ROAD_Y;
		new_command.extension = len;
		return new_command;
	}

	/* static */ function DEPOT(x, y, enter_offset)
	{
		local new_command = clone ::RoadSiteConstructionCommand;
		new_command.x = x;
		new_command.y = y;
		new_command.code = ConstructionCommand.CC_ROAD_DEPOT;
		new_command.extension = enter_offset;
		return new_command;
	}

	/* static */ function BUS_LOAD_TERMINAL(x, y, enter_offset)
	{
		local new_command = clone ::RoadSiteConstructionCommand;
		new_command.x = x;
		new_command.y = y;
		new_command.code = ConstructionCommand.CC_BUS_STATION;
		new_command.extension = {enter_offset = enter_offset, drop_only = false};
		return new_command;
	}

	/* static */ function TRUCK_LOAD_TERMINAL(x, y, enter_offset)
	{
		local new_command = clone ::RoadSiteConstructionCommand;
		new_command.x = x;
		new_command.y = y;
		new_command.code = ConstructionCommand.CC_TRUCK_STATION;
		new_command.extension = {enter_offset = enter_offset, drop_only = false};
		return new_command;
	}

	/* static */ function TRUCK_DROP_TERMINAL(x, y, enter_offset)
	{
		local new_command = clone ::RoadSiteConstructionCommand;
		new_command.x = x;
		new_command.y = y;
		new_command.code = ConstructionCommand.CC_TRUCK_STATION;
		new_command.extension = {enter_offset = enter_offset, drop_only = true};
		return new_command;
	}

	/* static */ function ROTATE_COMMAND(base_command)
	{
		local result = clone ::RoadSiteConstructionCommand;
		result.x = base_command.x;
		result.y = base_command.y;
		result.code = base_command.code;

		local get_next_offset = function(offset, dx, dy) {
			if (offset == dx) {
				return -dy;
			} else if (offset == -dx) {
				return dy;
			} else if (offset == dy) {
				return dx;
			} else if (offset == -dy) {
				return -dx;
			}
			assert(null);
		}

		switch (base_command.code) {
			case ConstructionCommand.CC_ROAD_X :
			case ConstructionCommand.CC_ROAD_Y :
				result.extension = base_command.extension;
				break;
			case ConstructionCommand.CC_ROAD_DEPOT :
				local dx = AIMap.GetTileIndex(1, 0);
				local dy = AIMap.GetTileIndex(0, 1);
				result.extension = get_next_offset(base_command.extension, dx, dy);
				break;
			case ConstructionCommand.CC_BUS_STATION :
			case ConstructionCommand.CC_TRUCK_STATION :
				local dx = AIMap.GetTileIndex(1, 0);
				local dy = AIMap.GetTileIndex(0, 1);
				result.extension = {
					drop_only = base_command.extension.drop_only,
					enter_offset = get_next_offset(base_command.extension.enter_offset, dx, dy),
				};
				break;
		}

		return result;
	}

	/* static */ function POINT_REFLECT_COMMAND(base_command)
	{
		local result = clone ::RoadSiteConstructionCommand;
		result.x = base_command.x;
		result.y = base_command.y;
		result.code = base_command.code;

		switch (base_command.code) {
			case ConstructionCommand.CC_ROAD_X :
			case ConstructionCommand.CC_ROAD_Y :
				result.extension = base_command.extension;
				break;
			case ConstructionCommand.CC_ROAD_DEPOT :
				result.extension = -base_command.extension;
				break;
			case ConstructionCommand.CC_BUS_STATION :
			case ConstructionCommand.CC_TRUCK_STATION :
				result.extension = {
					drop_only = base_command.extension.drop_only,
					enter_offset = -base_command.extension.enter_offset,
				};
				break;
		}

		return result;
	}

/* private */
}
