/**
 * Class that handles road routes creation for "heap" nodes.
 */
class HeapSupportTransportPolitics extends TransportPolitics
{
/* public */
	heap_top_transport_node = null;

	constructor(heap_top_transport_node)
	{
		::TransportPolitics.constructor();

		this.heap_top_transport_node = heap_top_transport_node;
	}

	function GetTransportNode(node)
	{
		if (node.IsBuiltOnWater()) return null;

		if (node.type_id != NodeTypeID.NT_TRANSIT_DROP) { 
			if (!node.IsTown()) return TruckHub(node, this);
			local min_pop = RoadSettings.lowest_population_limit_for_towns;
			return (node.IsPaxTown() || node.GetPopulation() < min_pop) ?
				null : TruckHub(node, this);
		}
		foreach (c, dummy in node.cargo_ids) {
			if (AICargo.IsFreight(c)) return TruckHub(node, this);
		}
		return null;
	}

	function GetRoutes(from_transport_node, to_transport_node, cargo_ids)
	{
		local s = from_transport_node.node;
		if (to_transport_node.node.node_id != this.heap_top_transport_node.node.node_id) return {};
		if (s.IsTown()) return {}; // routes only IN towns allowed
		local e = to_transport_node.node;

		local result = {};
		foreach (c, dummy_value in cargo_ids) {
			if (!from_transport_node.node.IsProducing(c)) continue;
			local road_route = RoadRoute(s, e, c, true);
			road_route.MakeNefarious(-1);
			result[road_route.GetID()] <- road_route;
		}
		return result;
	}

/* protected */
	function CanRoute(from_transport_node, to_transport_node)
	{
		if (to_transport_node.node.node_id != this.heap_top_transport_node.node.node_id) return false;

		local d = AIMap.DistanceManhattan(
			from_transport_node.node.location, to_transport_node.node.location
		);
		return (this.d_min <= d && d <= this.d_max);
	}

	function IntegrateNode(transport_node)
	{
		local c_ids = clone this.heap_top_transport_node.node.cargo_ids_to_feed;
		local new_link = GlobalTransportMap.Link.Create(
			transport_node, this.heap_top_transport_node, this, 1, c_ids
		);
		new_link.SetColor(LinkColor.LC_GREEN);
	}

	function FinalizeIntegration(truck_hub, transport_schema)
	{
		//Linker.RescaleNewNodeLinks(truck_hub);
	}

/* private */
	/** Min allowed road routes' length */
	d_min = 0

	/** Max allowed road routes' length */
	d_max = 35;
}
