require("aystar.nut");
require("rpf.nut");
require("routefinder.nut");
require("routebuilder.nut");
//import("queue.fibonacci_heap", "FibonacciHeap", 2); 

/**
 * Adapter for the pathfinder from the AdmiralAI(v22, author Thijs Marinussen).
 */
class AdmiralAIv22PathfinderAdapter
{
	/**
	 * Connect the two tiles.
	 */
	function ConnectTiles(s, e, road_type)
	{
		local old_road_type = RoadUtils.SetRoadType(road_type);
		local result = RouteBuilder.BuildRoadRoute(RPF(), [s], [e], 1.25, 20);
		AIRoad.SetCurrentRoadType(old_road_type);

		return result;
	}

	/**
	 * Connect the two tiles with new road.
	 */
	function ConnectTilesWithNewRoad(s, e)
	{
		local old_road_type = RoadUtils.SetRoadType(AIRoad.ROADTYPE_ROAD);

		//AISign.BuildSign(s, "s");
		//AISign.BuildSign(e, "e");
		local tiles_to_ignore_a = [], tiles_to_ignore_b = [];
		local sx = AIMap.GetTileX(s), sy = AIMap.GetTileY(s);
		local ex = AIMap.GetTileX(e), ey = AIMap.GetTileY(e);
		local dx = ex - sx, dy = ey - sy;
		local x_min = min(sx, ex), x_max = max(sx, ex);
		local y_min = min(sy, ey), y_max = max(sy, ey);
		for (local i = x_min; i <= x_max; i++) {
			for (local j = y_min; j <= y_max; j++) {
				local sign = (i - sx) * dy - (j - sy) * dx;
				local t = AIMap.GetTileIndex(i, j);
				if (AIMap.DistanceManhattan(t, s) <= 1) continue;
				if (AIMap.DistanceManhattan(t, e) <= 1) continue;
				if (sign > 0) {
					tiles_to_ignore_a.append(t);
				}
				if (sign < 0) {
					tiles_to_ignore_b.append(t);
				}
				if (sign == 0) {
					tiles_to_ignore_a.append(t);
					tiles_to_ignore_b.append(t);
				}
			}
		}

		local rpf1 = RPF(), rpf2 = RPF();
		rpf1._cost_turn = 1 + rpf1._max_cost / 3;
		rpf2._cost_turn = rpf1._cost_turn;
		RouteBuilder.BuildRoadRoute(rpf2, [s], [e], 1.25, 20, tiles_to_ignore_a);
		RouteBuilder.BuildRoadRoute(rpf1, [e], [s], 1.25, 20, tiles_to_ignore_b);
		AIRoad.SetCurrentRoadType(old_road_type);
	}

	/**
	 * Check if the two tiles are connected.
	 */
	function AreTilesConnected(s, e, road_type)
	{
		return this.FindRouteBetweenRects(s, e, 0, road_type);
	}

	/**
	 * Check if the two sets of tiles are connected.
	 */
	function AreTileSetsConnected(sources, goals, road_type)
	{
		local old_road_type = RoadUtils.SetRoadType(road_type);

		local valid_sources = [];
		foreach (dummy_id, t in sources) {
			valid_sources.push([t, 1]);
		}

		local d = (AIMap.DistanceManhattan(sources[0], goals[0]) * 1.2).tointeger();
		_RouteFinder_pf.InitializePath(valid_sources, goals, []);
		RouteFinder.max_cost <- 20 + d;
		RouteFinder.goal_tile <- goals[0];

		local path = _RouteFinder_pf.FindPath(-1);

		AIRoad.SetCurrentRoadType(old_road_type);
		return path != null;
	}

	/**
	 * Check if a route between the neighbourhoods of two points already exists.
	 */
	function FindRouteBetweenRects(s, e, r, road_type)
	{
		local old_road_type = RoadUtils.SetRoadType(road_type);
		local route = RouteFinder.FindRouteBetweenRects(s, e, r);
		AIRoad.SetCurrentRoadType(old_road_type);

		return route != null;
	}
}

class AdmiralAIv22PathfinderAdapter.LoopRoadRPF extends RPF
{
	function _Estimate(cur_tile, cur_direction, goal_tiles, self)
	{ 
		return AIMap.DistanceManhattan(cur_tile, self._goal_estimate_tile) * (self._cost_tile + self._cost_no_existing_road);
	}
}
