/**
 * Class that handles game map scanning for opponents stations.
 */
class ActivityMap extends Terron_Object
{
/* public */
	static function GetClassName()
	{
		return "ActivityMap";
	}

	/**
	 * Get opponents activity map object.
	 * @param transport_class_name Result will be restricted to
	 *  the transport nodes of this given transport class.
	 * @param node_types_to_scan Result will be restricted to
	 *  the nodes of this given types.
	 * @return ActivityMap object.
	 */
	static function GetActivityMap(transport_class_name, node_types_to_scan)
	{
		local result = ActivityMap();

		local tmp = GlobalTransportMap.Get().structured_transport_nodes;
		local repository = tmp[transport_class_name];
		foreach (type_id, dummy_value in node_types_to_scan) {
			foreach (dummy_id, road_node in repository[type_id]) {
				local activity = ActivityMap.GetActivity(road_node);
				if (activity > 0) result.map[road_node.GetID()] <- activity;
			}
		}

		return result;
	}

	/** Table: {transport node runtime ID, number of enemy station nearby}. */
	map = null;

	/**
	 * "Minus" operator.<p>
	 * See Squirrel manual.
	 */
	function _sub(op)
	{
		local result = ActivityMap();

		foreach (node_runtime_id, n in this.map) {
			local m = node_runtime_id in op.map ? op.map[node_runtime_id] : 0;
			if (n > m) result.map[node_runtime_id] <- (n - m);
		}
		return result;
	}

/* private */
	/**
	 * Get opponents activity near the given transport node.
	 * @param transport_node Transport node to chaeck.
	 */
	static function GetActivity(transport_node)
	{
		return transport_node.node.GetAmountOfOpponentsStationsAround();
	}

	/**
	 * ActivityMap private constructor.
	 */
	constructor()
	{
		::Terron_Object.constructor(null);

		this.map = {};
	}
}
