/**
 * Class that incapsulates town node extension to handle bus transportation.<p>
 */
class BusHub extends Hub
{
/* public */
	static function GetClassName()
	{
		return "BusHub";
	}

	/**
	 * Creates a new BusHub.
	 * @param town_node Base town node.
	 * @param transport_politics Hub control politics.
	 */
	constructor(town_node, transport_politics)
	{
		::Hub.constructor(town_node, transport_politics, 3);
		this.name = town_node.GetName() + " road hub";
	}
}
