/**
 * Class that handles bus hubs/routes generation.
 */
class TownToTownTransportPolitics extends TransportPolitics
{
/* public */
	constructor()
	{
		::TransportPolitics.constructor();

		local cfg = RoadSettings.Get();
		this.d_min = cfg.min_route_length;
		this.d_max = cfg.max_route_length;
		local pass_cargo_id = CorporationUtils.pass_cargo_id.value;
		local mail_cargo_id = CorporationUtils.mail_cargo_id.value;
		this.shipments = TransportSchema.Get().GetShipmentsList(NodeTypeID.NT_PAX_TOWN, NodeTypeID.NT_PAX_TOWN);
		foreach (c, dummy in (clone this.shipments)) {
			if (c != pass_cargo_id && c != mail_cargo_id) {
				delete this.shipments[c];
			}
		}
	}

	function GetTransportNode(node)
	{
		if (!node.IsTown()) return null;

		local min_pop = RoadSettings.lowest_population_limit_for_towns;
		return (node.IsPaxTown() && node.GetPopulation() > min_pop) ?
			BusHub(node, this) : null;
	}

	function GetRoutes(from_transport_node, to_transport_node, cargo_ids)
	{
		local s = from_transport_node.node;
		local e = to_transport_node.node;
		local result = {};
		foreach (c, dummy_value in cargo_ids) {
			local road_route = RoadRoute(s, e, c, false);
			result[road_route.GetID()] <- road_route;
		}
		return result;
	}

/* protected */
	function IntegrateNode(bus_hub)
	{
		local bus_hubs = GlobalTransportMap.Get().structured_transport_nodes["BusHub"][NodeTypeID.NT_PAX_TOWN];
		local t = bus_hub.node.location;
		local LINK = GlobalTransportMap.Link;
		local distance_manhattan = AIMap.DistanceManhattan;
		foreach (dummy_id, e in bus_hubs) {
			local d = distance_manhattan(t, e.node.location);
			if (d > this.d_max) continue;
			if (d >= this.d_min) LINK.Create(e, bus_hub, this, 0, this.shipments);
		}
	}

/* private */
	/** Min allowed road routes' length */
	d_min = 0

	/** Max allowed road routes' length */
	d_max = 0;

	/** Table with town-to-town shipments */
	shipments = null;
}
