/**
 * Class that controls build process for the PaxTransitControlSection.
 */
class PaxTransitControlSection_LocalBuildStrategy extends DefaultRoadConstructionStrategy
{
/* public */
	function SelectObjectToBuild()
	{
		local best_route = null;
		local best_rank = APriority.BAD;

		local c = CorporationUtils.pass_cargo_id.value;
		local global = GlobalTransportMap.Get().structured_transport_nodes;
		local transit_nodes = global[PaxTransitHub.GetClassName()][NodeTypeID.NT_TRANSIT_DROP];
		foreach (dummy_id, transit_node in transit_nodes) {
			local id = transit_node.node.GetStationID();
			local rating = AIStation.GetCargoRating(id, c);
			local waiting = AIStation.GetCargoWaiting(id, c);
			if (rating < 50 && waiting > 400) continue;
			if (rating < 35 || waiting > 1250) continue;

			local list = AIVehicleList_Station(id);
			local n = list.Count();
			list.Valuate(AIVehicle.GetVehicleType);
			list.KeepValue(AIVehicle.VT_ROAD);
			if (list.Count() >= n - 1) continue;

			local total_routes = 0;
			local saturated_routes = 0;
			foreach (link_id, link in transit_node.links_in) {
				foreach (dummy_route_id, route in link.routes) {
					foreach (dummy_trade_id, trade_route in route.trade_routes) {
						total_routes++;
						if ((!trade_route.IsEnabled()) || trade_route.IsSaturated()) {
							saturated_routes++;
						}
					}
				}
			}
			if (saturated_routes <= total_routes - 2) continue;

			if (total_routes == 0 && rating > 65 && waiting < 40) {
				local len = 2048;
				foreach (link_id, link in transit_node.links_in) {
					foreach (dummy_route_id, route in link.routes) {
						if (route.length < len &&
							this.RankRoadRoute(route) > APriority.BAD) {
								best_route = route;
								len = route.length;
						}
					}
				}
				if (best_route != null) {
					return {priority = APriority.MAX, context = best_route};
				}
			}

			foreach (link_id, link in transit_node.links_in) {
				foreach (dummy_route_id, route in link.routes) {
					local r = this.RankRoadRoute(route);
					if (r > best_rank) {
						best_route = route;
						best_rank = r;
					}
				}
			}
		}

		return {priority = best_rank, context = best_route};
	}

	function Build(route)
	{
		return RoadRouteBuilder.BuildRoute(route, this.GetDefaultPathfinder());
	}

	function HandleResult(result, route)
	{
		local err_code = result.err_code;
		/* Building failed, stop future retrying then... */
		if (err_code == -3 || err_code == -1) {
			// ...at least for year
			route.MakeNefarious(GameTime.YEAR);
			return -1;
		}

		/* Route complete */
		if (err_code == 0) {
			local s = result.s_station;
			local e = result.e_station;
			/* Start trade control */
			local trade_route = this.FoundNewTradeRoute(route, s, e);

			/* Do not expand(much) stations built for transfer service */
			local s = trade_route.s_stop;
			foreach (dummy, terminal in s.station_plan.GetLoadingTerminals()) {
				terminal.core.max_upgrades_allowed = 2;
			}

			/* Suspend some routes building, to lazy renew cached values */
			local s = route.GetStart();
			local tmp = GlobalTransportMap.Get().structured_transport_nodes;
			s = tmp[PaxTransitHub.GetClassName()][s.GetTypeID()][s.node_id];
			foreach (dummy_link_id, link in s.links_out) {
				if (link.color != LinkColor.LC_GREEN) continue;
				foreach (dummy_route_id, to_suspend_route in link.routes) {
					to_suspend_route.MakeNefarious(32 * GameTime.DAY);
				}
			}
		}

		return err_code;
	}
}
