/**
 * Class that handles pass transit organization.
 */
class PaxTransitControlSection extends AbstractTransportSystem
{
/* public */
	static function GetClassName()
	{
		return "PaxTransitControlSection";
	}

	static function Restore(memento)
	{
		return PaxTransitControlSection();
	}

	/**
	 * PaxTransitControlSection constructor.
	 */
	constructor()
	{
		::AbstractTransportSystem.constructor();

		local a_name = "Building pax transit route..."
		local strategy = PaxTransitControlSection_LocalBuildStrategy();
		local t = 22 * GameTime.DAY;
		this.best_action = UniversalAction(a_name, strategy, 4 * t, t);
		this.transport_politics = PaxTransitTransportPolitics();

		GlobalTransportMap.Get().SetUpNewTransportNodeClass(PaxTransitHub.GetClassName());

		NewNodeEvent.AddListener(this);
		AIStartedEvent.AddListener(this);
	}

	function GetName()
	{
		return "SuperPaxTransitHub";
	}

	/**
	 * Intgrate new node into freight network.
	 * @param node New game node.
	 */
	function OnNewNode(node)
	{
		this.transport_politics.EnableTransportNode(node);
	}

	/**
	 * Restore own trade lines after game load.
	 */
	function OnAIStarted(is_game_loaded)
	{
		if (is_game_loaded) {
			local a = AISearchRoadTradeRoutesAction(PaxTransitHub.GetClassName());
			Corporation.Get().AddAction(a);
		}
	}

/* protected */
	function doGetBestAction()
	{
		return this.best_action;
	}

/* private */
	/** Currently best action to extend transit network. */
	best_action = null;

	/** Pax transit routes handling strategy. */
	transport_politics = null;
}

Terron_ClassTable.RegisterClass(PaxTransitControlSection);
