/**
 * Class that containes/[provides access to] information about built buoys.
 */
class BuiltWaterPathsRegister extends Terron_SaveableObject
{
/* public */
	static function GetClassName()
	{
		return "BuiltWaterPathsRegister";
	}

	static function Restore(memento)
	{
		local restored = BuiltWaterPathsRegister();

		foreach (dummy_id, info in memento.sequences_info) {
			local from = info[0];
			local to = info[1];
			local buoys = info.slice(2, info.len());
			restored.RegisterBuoySequence(from, to, buoys);
		}

		return restored;
	}

	/**
	 * BuiltWaterPathsRegister class constructor.
	 */
	constructor()
	{
		::Terron_SaveableObject.constructor(null);
		this.buoy_sequences = TableContainer.new("Buoy sequences");
	}

	function GetMemento()
	{ 
		local memento = {sequences_info = []};
		foreach (from, from_table in this.buoy_sequences) {
			foreach (to, arr in from_table) {
				local tmp = [from, to];
				tmp.extend(arr);
				memento.sequences_info.append(tmp);
			}
		}
		return memento;
	}

	function GetName()
	{
		return "Built water paths container";
	}

	/**
	 * Get the buoy path between the given docks.
	 * @param dock_station_id_from ID of the first dock station.
	 * @param dock_station_id_to ID of the second dock station.
	 * @return Array with tile IDs of the buoys(can be empty),
	 *  or null if such path is not known.
	 */
	function GetBuoySequence(dock_station_id_from, dock_station_id_to)
	{
		/*if (dock_station_id_from > dock_station_id_to) {
			return this.GetBuoySequence(dock_station_id_to, dock_station_id_from);
		}*/

		if (!(dock_station_id_from in this.buoy_sequences)) return null;

		local from_paths = this.buoy_sequences[dock_station_id_from];
		return (dock_station_id_to in from_paths) ?
			from_paths[dock_station_id_to] : null;
	}

	/**
	 * Add new buoy sequence to this register.
	 * @param dock_station_id_from ID of the first dock station.
	 * @param dock_station_id_to ID of the second dock station.
	 * @param arr Array with tile IDs of the buoys, which can be empty.
	 */
	function RegisterBuoySequence(dock_station_id_from, dock_station_id_to, arr)
	{
		assert(arr);

		/*if (dock_station_id_from > dock_station_id_to) {
			local reversed_buoys = clone arr;
			reversed_buoys.reverse();
			return this.RegisterBuoySequence(dock_station_id_to, dock_station_id_from, reversed_buoys);
		}*/
		if (!(dock_station_id_from in this.buoy_sequences)) {
			local s = "Buoy sequences from dock " + dock_station_id_from;
			this.buoy_sequences[dock_station_id_from] <- TableContainer.new(s);
		}
		this.buoy_sequences[dock_station_id_from][dock_station_id_to] <- arr;

		if (!(dock_station_id_to in this.buoy_sequences)) {
			local s = "Buoy sequences from dock " + dock_station_id_to;
			this.buoy_sequences[dock_station_id_to] <- TableContainer.new(s);
		}
		local reversed_buoys = clone arr;
		reversed_buoys.reverse();
		this.buoy_sequences[dock_station_id_to][dock_station_id_from] <- reversed_buoys;

		Terron.UpdateMemento();
	}

	/**
	 * Remove buoy sequence from the register.
	 */
	function RemoveBuoySequence(dock_station_id_from, dock_station_id_to)
	{
		if (dock_station_id_from in this.buoy_sequences) {
			this.buoy_sequences[dock_station_id_from].rawdelete(dock_station_id_to);
		}

		if (dock_station_id_to in this.buoy_sequences) {
			this.buoy_sequences[dock_station_id_to].rawdelete(dock_station_id_from);
		}

		Terron.UpdateMemento();
	}

	/**
	 * Remove any information about the given dock.
	 * @param dock_station_id ID of the dock station to remove.
	 */
	function RemoveAllDockPaths(dock_station_id)
	{
		if (dock_station_id in this.buoy_sequences) {
			delete this.buoy_sequences[dock_station_id];
		}

		foreach (dummy, from_buoy_sequences in this.buoy_sequences) {
			if (dock_station_id in from_buoy_sequences) {
				delete from_buoy_sequences[dock_station_id];
			}
		}

		Terron.UpdateMemento();
	}

/* private */
	/**
	 * 2D map with from/to dock stations IDs as keys,
	 *  and arrays of buoy tile IDs as values.
	 */
	</ must_save = true />
	buoy_sequences = null;
}

Terron_ClassTable.RegisterClass(BuiltWaterPathsRegister);
