/**
 * Class that describes routes requiring one(and only one) engine type.
 * This means: built route do not use several different engines(e.g. locos)
 *  to transport cargo AND route's vehicles do not require dynamic refit during
 *  cargo transportation. Actual engine type can change with time,
 *  but it's always represent one("best") engine for such routes.
 */
class SingleEngineRoute extends AIAbstractRoute
{
/* public */
	/**
	 * SingleEngineRoute constructor.
	 * @param name Desired route's name.
	 * @param cargo_id ID of the cargo to transport. 
	 */
	constructor(name, cargo_id)
	{
		::AIAbstractRoute.constructor(name);

		this.cargo_id = cargo_id;

		this.engine = Property(
			this.doGetEngine.bindenv(this),
			GameTime.ENGINE_REVIEW_INTERVAL
		);
		this.engine.SetName("Get best engine for route [" + this.name + "]");
	}

	/**
	 * Get ID of the best engine for this route.
	 * @return Engine id; supposed to be best for this route.
	 */
	function GetEngine()
	{
		return this.engine.Get();
	}

	/** Get this route cargo id */
	function GetCargoID()
	{
		return this.cargo_id;
	}

/* protected */
	/** The route's cargo */
	cargo_id = null;

	/** Best engine for this route */
	engine = null;

	/**
	 * Get ID of the best engine for this route.
	 * @return EngineID or -1 if none of suitable engines available.
	 */
	function doGetEngine();
}
