/**
 * Class to handle station special "unloading" terminals - these specialize
 *  <b>only</b> in cargo drop from the vehicles to station.<p>
 */
class Station_CargoDropTerminal extends Station_Terminal
{
	static function GetClassName()
	{
		return "Station_CargoDropTerminal";
	}

	/** Array of cargo IDs which this terminal can accept */
	cargo_list = null;

	/**
	 * Creates cargo drop terminal.
	 * @param station_id ID of the host station.
	 * @param cargo_list List with cargo IDs that the terminal can accept.
	 */
	constructor(station_id, cargo_list)
	{
		::Station_Terminal.constructor(station_id);
		this.cargo_list = TableContainer.new("Cargo list");
		foreach (dummy_id, c in cargo_list) {
			this.cargo_list[c] <- c;
		}
	}

	function GetName()
	{
		return AIStation.GetName(this.station_id) + " cargo drop terminal";
	}

	function UnloadOnly() { return true;}
}
