/**
 * Class that creates AI town actions.
 */
class CentralTownPoliticsHandlingSection extends AbstractTransportSystem
{
/* public */
	static function GetClassName()
	{
		return "CentralTownPoliticsHandlingSection";
	}

	static function Restore(memento)
	{
		return CentralTownPoliticsHandlingSection();
	}

	constructor()
	{
		::AbstractTransportSystem.constructor();
		this.AddSubsystem(WorkUnit(StatueBuildStrategy()));
		this.AddSubsystem(WorkUnit(BribeTownStrategy()));
		this.AddSubsystem(WorkUnit(BuyRightsTownAction()));
		if (AIController.GetSetting("fund_town_buildings") > 0) {
			this.AddSubsystem(WorkUnit(FundBuildingsStrategy()));
		}
	}

	function GetName()
	{
		return "Bribery Department";
	}
}

/**
 * Class that control AI town action.
 */
class CentralTownPoliticsHandlingSection.WorkUnit extends AbstractTransportSystem
{
/* public */
	static function GetClassName()
	{
		return "CentralTownPoliticsHandlingSection.WorkUnit";
	}

	constructor(town_action_strategy)
	{
		::AbstractTransportSystem.constructor();
		this.town_strategy = town_action_strategy;
		local name = town_action_strategy.GetStrategyName();
		local t = GameTime.MONTH;
		this.best_action = UniversalAction(name, town_action_strategy 5 * t, t);
	}

/* protected */
	function doGetBestAction()
	{
		if (this.town_strategy.IsStopped()) {
			this.town_strategy.UpdateTownList();
			this.best_action.ForceUpdate();
		}
		return this.town_strategy.IsStopped() ? null : this.best_action;
	}

/* private */
	/** Action that should perform town manipulations. */
	best_action = null;

	/** Corresponding town action strategy. */
	town_strategy = null;
}

Terron_ClassTable.RegisterClass(CentralTownPoliticsHandlingSection);
