/**
 * Class that holds engines' parameters.
 */
class EnginesInfo extends Terron_Settings
{
/* public */
	/**
	 * Table that hold engines' stats.
	 * Key - engine's ID.
	 * Value - array with the engine's stats.
	 * @note Saves up to 40% of ticks.
	 */
	static stats = {};

	static function GetClassName()
	{
		return "EnginesInfo";
	}

	static function Restore(memento)
	{
		return EnginesInfo();
	}

	/**
	 * Set correct stats for the given engine.
	 * @param e Engine ID.
	 */
	static function CalculateEngineStats(e)
	{
		local stats = EnginesInfo.stats;
		if (!AIEngine.IsValidEngine(e)) {
			/* Dummy values for capacity, max age, max speed, e.t.c */
			stats[e] <- [1, 10, 5, 1 << 20, 10, 10000, 1, 0];
			return;
		}

		if (!(e in stats)) {
			stats[e] <- [
				AIEngine.GetCapacity(e),
				AIEngine.GetMaxAge(e),
				AIEngine.GetMaxSpeed(e),
				AIEngine.GetPrice(e),
				AIEngine.GetReliability(e),
				AIEngine.GetRunningCost(e) / GameTime.MONTHS_PER_YEAR,
				AIDate.GetYear(AIEngine.GetDesignDate(e)),
				0,
			];
			return;
		}

		local e_stats = stats[e];
		e_stats[EngineStat.ES_PRICE] = AIEngine.GetPrice(e);
		e_stats[EngineStat.ES_RELIABILITY] = AIEngine.GetReliability(e);
		e_stats[EngineStat.ES_MONTH_RUNNING_COST] =	AIEngine.GetRunningCost(e) / GameTime.MONTHS_PER_YEAR;
	}

	/**
	 * Update engines' parameters.
	 */
	function UpdateAllStats()
	{
		foreach (e, dummy in this.stats) {
			this.stats[e][EngineStat.ES_PRICE] = AIEngine.GetPrice(e);
			this.stats[e][EngineStat.ES_RELIABILITY] = AIEngine.GetReliability(e);
			this.stats[e][EngineStat.ES_MONTH_RUNNING_COST] = AIEngine.GetRunningCost(e) / GameTime.MONTHS_PER_YEAR;
			this.stats[e][EngineStat.ES_DESIGN_YEAR] = AIDate.GetYear(AIEngine.GetDesignDate(e));
		}
	}

/* protected */
	constructor()
	{
		::Terron_Settings.constructor();

		local t = GameTime.ENGINE_REVIEW_INTERVAL;
		RecheckEnginesStatsTask(AIDate.GetCurrentDate() + t, t);
		AISettingsSaveEvent.RemoveListener(this);
	}
}

/**
 * Class that handles engines's stats updates.
 */
class RecheckEnginesStatsTask extends Terron_Task
{
/* public */
	function GetName()
	{
		return "Engine stats check task";
	}

/* protected */
	function Execute()
	{
		EnginesInfo.Get().UpdateAllStats();
	}
}

Terron_ClassTable.RegisterClass(EnginesInfo);
