/**
 * Visitor class that search objects belonging to given class.
 * It will scan given transport system (use Visit function),
 * and return (use GetResult function) all it's parts,
 * which are the instances of the class with given name (constructor param).
 * For debug.
 */
class VGetItemsByType extends Visitor
{
/* public */
	/**
	 * Creates a VGetItemsByType visitor object.
	 * @param classname_to_search class name to search objects.
	 */
	constructor(classname_to_search)
	{
		this.classname_to_search = classname_to_search;
		this.result = TableContainer.new("Vistor Result");
	}

	/**
	 * Get the visit result.
	 * @return table, containing founded objects.
	 */
	function GetResult()
	{
		return this.result;
	}

/* protected */
	function doVisit(item)
	{
		if (item.GetClassName() == this.classname_to_search) this.result.AddItem(item);
	}

/* private */
	/** String, indicating objects to search class name */
	classname_to_search = null;

	/** Table to store found objects */
	result = null;
}
