import("pathfinder.rail", "RailPathFinder", 1);
require("money.nut");
require("util.nut");

class RailManager {
	started = false;
	pathfinder = RailPathFinder();
	function ExpandRailNetwork();
}

function RailManager::ExpandRailNetwork() {
	if (started){
		return false;
	}
	else {
		local types = AIRailTypeList();
		AIRail.SetCurrentRailType(types.Begin());
		started = true;
	}
	AILog.Info("building train station");
	local industries = AIIndustryList();
	local i1 = industries.Begin();
	industries.Valuate(AIIndustry.GetDistanceManhattanToTile, AIIndustry.GetLocation(i1));
	industries.Sort(AIList.SORT_BY_VALUE, true);
	industries.Begin();
	local i2 = industries.Next();
	AILog.Info("connecting "+AIIndustry.GetName(i1)+" to "+AIIndustry.GetName(i2));
	local t1 = BuildStation(AITileList_IndustryProducing(i1, AIStation.GetCoverageRadius(AIStation.STATION_TRAIN)));
	local t2 = BuildStation(AITileList_IndustryProducing(i2, AIStation.GetCoverageRadius(AIStation.STATION_TRAIN)));
	if (t1 != null && t2 != null){
		AISign.BuildSign(t1, "t1");
		AISign.BuildSign(t2, "t2");
		if (BuildRoute([t1 + AIMap.GetTileIndex(4, 0), t1 + AIMap.GetTileIndex(3, 0)], [t2 + AIMap.GetTileIndex(4, 0), t2 + AIMap.GetTileIndex(3, 0)])){
			if (!AIRail.BuildRailStation(t1, AIRail.RAILTRACK_NE_SW, 1, 4, AIStation.STATION_NEW)){
				AILog.Warning(AIError.GetLastErrorString());
			}
			if (!AIRail.BuildRailStation(t2, AIRail.RAILTRACK_NE_SW, 1, 4, AIStation.STATION_NEW)){
				AILog.Warning(AIError.GetLastErrorString());
			
			}
		}
	}
	else {
		AILog.Warning("t1: "+t1+" t2: "+t2);
	}
	return true;
}

function RailManager::BuildRoute(ts1, ts2){
	pathfinder.InitializePath([ts1], [ts2]);
	local path = pathfinder.FindPath(-1);
	if (path == null){
		AILog.Warning("No path found");
		return false;
	}
	else {
		AILog.Info("path found, building...");
	}
	local prev = null;
	local prevprev = null;
	while (path != null) {
	    if (prevprev != null) {
			if (AIMap.DistanceManhattan(prev, path.GetTile()) > 1) {
				if (AITunnel.GetOtherTunnelEnd(prev) == path.GetTile()) {
					AITunnel.BuildTunnel(AIVehicle.VT_RAIL, prev);
				} else {
					local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), prev) + 1);
					bridge_list.Valuate(AIBridge.GetMaxSpeed);
					bridge_list.Sort(AIList.SORT_BY_VALUE, false);
					AIBridge.BuildBridge(AIVehicle.VT_RAIL, bridge_list.Begin(), prev, path.GetTile());
				}
				prevprev = prev;
				prev = path.GetTile();
				path = path.GetParent();
			} else {
				AIRail.BuildRail(prevprev, prev, path.GetTile());
			}
	    }
	    if (path != null) {
			prevprev = prev;
			prev = path.GetTile();
			path = path.GetParent();
		}
	}
	AILog.Info("Finished building path");
	return true;
}

function RailManager::IsClearSize(tile, sx, sy) {
	local tiles = AITileList();
	tiles.AddRectangle(tile, tile + AIMap.GetTileIndex(sx - 1, sy - 1));
	local size = tiles.Count();
	if (size != sx * sy){
		return false;
	}
	
	tiles.Valuate(AITile.GetSlope);
	tiles.KeepValue(AITile.SLOPE_FLAT);
	tiles.Valuate(AITile.IsBuildable);
	tiles.KeepValue(1);
	return tiles.Count() == size;
}

function RailManager::BuildStation(tileSet) {
	local number = tileSet.Count();
	tileSet.Valuate(AITile.GetSlope);
	tileSet.KeepValue(AITile.SLOPE_FLAT);
	tileSet.Valuate(AITile.IsBuildable);
	tileSet.KeepValue(1);
	tileSet.Valuate(IsClearSize, 6, 1);
	tileSet.KeepValue(1);
	if (!tileSet.IsEmpty()){
		local tile = tileSet.Begin();
		if (false && !AIRail.BuildRailStation(tile, AIRail.RAILTRACK_NE_SW, 1, 4, AIStation.STATION_NEW)){
			AILog.Warning("Failed building station: "+AIError.GetLastErrorString());
		}
		else {
			return tile;
		}
	}
	else {
		AILog.Warning("Empty tile set, was "+number);
	}
}