class Depot
{
    constructor(transportType, subType, location, front)
    {
	this.transportType = transportType;
	this.subType = subType;
	this.location = location;
	this.front = front;
    }

    transportType = null;
    subType = null;
    location = null;
    front = null;

    static _logger = Log.GetLogger("Depot");

    function Destroy();
    static function BuildRandom(transportType, subType);
    static function Build(transportType, subType, location);



};


function Depot::Build(transportType, subType, location, front)
{
    switch( transportType )
    {
    case AITile.TRANSPORT_ROAD:
	local prev = AIRoad.GetCurrentRoadType();
	AIRoad.SetCurrentRoadType(subType);
	local ok = AIRoad.BuildRoadDepot(location, front);
	AIRoad.SetCurrentRoadType(prev);
	if (ok)
	{
	    return Depot(transportType, subType, location, front);
	}
	else
	{
	    return null;
	}
	break;
    default:
	throw "Can only build depots for trucks and trams";
    }

}

/*
 * Build a depot of the given type on a random location
 * Subtype depends on transport type, it could be for example a roadType (tram etc.)
 */
function Depot::BuildRandom(transportType, subType)
{
    local depot = null;
    while(depot == null)
    {
	local location = randomTile();
	local direction = shuffle(DIRECTIONS)[0];
	local front = location + direction;
	depot = Depot.Build(transportType, subType, location, front);
    }
    return depot;
}


function Depot::Destroy()
{
    switch( transportType )
    {
    case AITile.TRANSPORT_ROAD:
	local result = AIRoad.RemoveRoadDepot(location);
	break;
    default:
	throw "Can only remove depots for trucks and trams";
    }



}