require("trucks.nut")

class TramTransport extends RoadTransport
{
    constructor()
    {
	::RoadTransport.constructor();
	_logger = Log.GetLogger("TramTransport");
    }
    function RoadType();
    function GetDescription();
    function BuildStation(orig, dest, vehicleType, stationType);

}


function TramTransport::RoadType()
{
    return AIRoad.ROADTYPE_TRAM;
}


function TramTransport::GetDescription()
{
    return "tram";
}


function TramTransport::BuildStation(orig, dest, vehicleType, stationType)
{
    local built = AIRoad.BuildDriveThroughRoadStation(orig, dest, vehicleType, stationType);
    if (built) 
    {
        // FIXME: What if we can't build the road ?
        local back = orig - (dest-orig);
        AIRoad.BuildRoad(orig, back);
    }
    return built;
}



function RoadTransport::_DepotsNeedFinalRoad()
{
    return false;
}
