// Money and loans related functionality

MINIMUM_WORKING_BALANCE <- 150000
MAXIMUM_WORKING_BALANCE <- 200000
DESIRED_WORKING_BALANCE <- 0

function GetLoan()
{
    if ( AICompany.GetBankBalance(AICompany.COMPANY_SELF) < MINIMUM_WORKING_BALANCE  
	|| AICompany.GetBankBalance(AICompany.COMPANY_SELF) < DESIRED_WORKING_BALANCE )
	return AICompany.SetLoanAmount(AICompany.GetLoanAmount()+50000);
}


function RepayLoan()
{
    if ( AICompany.GetBankBalance(AICompany.COMPANY_SELF) > MAXIMUM_WORKING_BALANCE 
	&& AICompany.GetBankBalance(AICompany.COMPANY_SELF) > DESIRED_WORKING_BALANCE )
        return AICompany.SetLoanAmount(max(AICompany.GetLoanAmount()-10000,0));
}


function CanSpend(cost)
{
    return cost + 1000 < AICompany.GetBankBalance(AICompany.COMPANY_SELF);
}


function ResetDesiredBalance()
{
    DESIRED_WORKING_BALANCE = 0;
}


// Set the desired working balance to be *at least* this amount
function RequireBalance(amount) 
{
    if (DESIRED_WORKING_BALANCE < amount) 
    {
        DESIRED_WORKING_BALANCE = amount;
    }
}

